/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterativeSolver;
import cern.colt.matrix.tfloat.algo.solver.FloatNotConvergedException;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;
import cern.jet.math.tfloat.FloatFunctions;

public class FloatBiCG
extends AbstractFloatIterativeSolver {
    private FloatMatrix1D z;
    private FloatMatrix1D p;
    private FloatMatrix1D q;
    private FloatMatrix1D r;
    private FloatMatrix1D ztilde;
    private FloatMatrix1D ptilde;
    private FloatMatrix1D qtilde;
    private FloatMatrix1D rtilde;

    public FloatBiCG(FloatMatrix1D template) {
        this.z = template.copy();
        this.p = template.copy();
        this.q = template.copy();
        this.r = template.copy();
        this.ztilde = template.copy();
        this.ptilde = template.copy();
        this.qtilde = template.copy();
        this.rtilde = template.copy();
    }

    @Override
    public FloatMatrix1D solve(FloatMatrix2D A, FloatMatrix1D b, FloatMatrix1D x) throws IterativeSolverFloatNotConvergedException {
        this.checkSizes(A, b, x);
        float rho_1 = 1.0f;
        float rho_2 = 1.0f;
        float alpha = 1.0f;
        float beta = 1.0f;
        A.zMult(x, this.r.assign(b), -1.0f, 1.0f, false);
        this.rtilde.assign(this.r);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, x)) {
            this.M.apply(this.r, this.z);
            this.M.transApply(this.rtilde, this.ztilde);
            rho_1 = this.z.zDotProduct(this.rtilde);
            if ((double)rho_1 == 0.0) {
                throw new IterativeSolverFloatNotConvergedException(FloatNotConvergedException.Reason.Breakdown, "rho", this.iter);
            }
            if (this.iter.isFirst()) {
                this.p.assign(this.z);
                this.ptilde.assign(this.ztilde);
            } else {
                beta = rho_1 / rho_2;
                this.p.assign(this.z, FloatFunctions.plusMultFirst(beta));
                this.ptilde.assign(this.ztilde, FloatFunctions.plusMultFirst(beta));
            }
            A.zMult(this.p, this.q);
            A.zMult(this.ptilde, this.qtilde, 1.0f, 0.0f, true);
            alpha = rho_1 / this.ptilde.zDotProduct(this.q);
            x.assign(this.p, FloatFunctions.plusMultSecond(alpha));
            this.r.assign(this.q, FloatFunctions.plusMultSecond(-alpha));
            this.rtilde.assign(this.qtilde, FloatFunctions.plusMultSecond(-alpha));
            rho_2 = rho_1;
            this.iter.next();
        }
        return x;
    }
}

