/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.decomposition;

import cern.colt.matrix.tfloat.FloatFactory2D;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.FloatProperty;
import cern.jet.math.tfloat.FloatFunctions;
import java.io.Serializable;

public class DenseFloatCholeskyDecomposition
implements Serializable {
    static final long serialVersionUID = 1020L;
    private FloatMatrix2D L;
    private FloatMatrix2D Lt;
    private int n;
    private boolean isSymmetricPositiveDefinite;

    public DenseFloatCholeskyDecomposition(FloatMatrix2D A) {
        int j;
        FloatProperty.DEFAULT.checkSquare(A);
        this.n = A.rows();
        this.L = A.like(this.n, this.n);
        this.isSymmetricPositiveDefinite = A.columns() == this.n;
        FloatMatrix1D[] Lrows = new FloatMatrix1D[this.n];
        for (j = 0; j < this.n; ++j) {
            Lrows[j] = this.L.viewRow(j);
        }
        for (j = 0; j < this.n; ++j) {
            int k;
            float d = 0.0f;
            for (k = 0; k < j; ++k) {
                float s = Lrows[k].zDotProduct(Lrows[j], 0, k);
                s = (A.getQuick(j, k) - s) / this.L.getQuick(k, k);
                Lrows[j].setQuick(k, s);
                d += s * s;
                this.isSymmetricPositiveDefinite = this.isSymmetricPositiveDefinite && A.getQuick(k, j) == A.getQuick(j, k);
            }
            d = A.getQuick(j, j) - d;
            this.isSymmetricPositiveDefinite = this.isSymmetricPositiveDefinite && (double)d > 0.0;
            this.L.setQuick(j, j, (float)Math.sqrt(Math.max((double)d, 0.0)));
            for (k = j + 1; k < this.n; ++k) {
                this.L.setQuick(j, k, 0.0f);
            }
        }
        this.Lt = this.L.viewDice().copy();
    }

    public FloatMatrix2D getL() {
        return this.L;
    }

    public FloatMatrix2D getLtranspose() {
        return this.Lt;
    }

    public boolean isSymmetricPositiveDefinite() {
        return this.isSymmetricPositiveDefinite;
    }

    public FloatMatrix2D solve(FloatMatrix2D B) {
        FloatMatrix2D X = B.copy();
        int nx = B.columns();
        for (int c = 0; c < nx; ++c) {
            int k;
            float sum;
            int i;
            for (i = 0; i < this.n; ++i) {
                sum = B.getQuick(i, c);
                for (k = i - 1; k >= 0; --k) {
                    sum -= this.L.getQuick(i, k) * X.getQuick(k, c);
                }
                X.setQuick(i, c, sum / this.L.getQuick(i, i));
            }
            for (i = this.n - 1; i >= 0; --i) {
                sum = X.getQuick(i, c);
                for (k = i + 1; k < this.n; ++k) {
                    sum -= this.L.getQuick(k, i) * X.getQuick(k, c);
                }
                X.setQuick(i, c, sum / this.L.getQuick(i, i));
            }
        }
        return X;
    }

    public FloatMatrix1D solve(FloatMatrix1D b) {
        int k;
        float sum;
        int i;
        FloatMatrix1D x = b.copy();
        for (i = 0; i < this.n; ++i) {
            sum = b.getQuick(i);
            for (k = i - 1; k >= 0; --k) {
                sum -= this.L.getQuick(i, k) * x.getQuick(k);
            }
            x.setQuick(i, sum / this.L.getQuick(i, i));
        }
        for (i = this.n - 1; i >= 0; --i) {
            sum = x.getQuick(i);
            for (k = i + 1; k < this.n; ++k) {
                sum -= this.L.getQuick(k, i) * x.getQuick(k);
            }
            x.setQuick(i, sum / this.L.getQuick(i, i));
        }
        return x;
    }

    private FloatMatrix2D XXXsolveBuggy(FloatMatrix2D B) {
        int i;
        int k;
        FloatFunctions F = FloatFunctions.functions;
        if (B.rows() != this.n) {
            throw new IllegalArgumentException("Matrix row dimensions must agree.");
        }
        if (!this.isSymmetricPositiveDefinite) {
            throw new IllegalArgumentException("Matrix is not symmetric positive definite.");
        }
        FloatMatrix2D X = B.copy();
        int nx = B.columns();
        FloatMatrix1D[] Xrows = new FloatMatrix1D[this.n];
        for (k = 0; k < this.n; ++k) {
            Xrows[k] = X.viewRow(k);
        }
        for (k = 0; k < this.n; ++k) {
            for (i = k + 1; i < this.n; ++i) {
                Xrows[i].assign(Xrows[k], FloatFunctions.minusMult(this.L.getQuick(i, k)));
            }
            Xrows[k].assign(FloatFunctions.div(this.L.getQuick(k, k)));
        }
        for (k = this.n - 1; k >= 0; --k) {
            Xrows[k].assign(FloatFunctions.div(this.L.getQuick(k, k)));
            for (i = 0; i < k; ++i) {
                Xrows[i].assign(Xrows[k], FloatFunctions.minusMult(this.L.getQuick(k, i)));
            }
        }
        return X;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String unknown = "Illegal operation or error: ";
        buf.append("--------------------------------------------------------------------------\n");
        buf.append("CholeskyDecomposition(A) --> isSymmetricPositiveDefinite(A), L, inverse(A)\n");
        buf.append("--------------------------------------------------------------------------\n");
        buf.append("isSymmetricPositiveDefinite = ");
        try {
            buf.append(String.valueOf(this.isSymmetricPositiveDefinite()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        buf.append("\n\nL = ");
        try {
            buf.append(String.valueOf(this.getL()));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        buf.append("\n\ninverse(A) = ");
        try {
            buf.append(String.valueOf(this.solve(FloatFactory2D.dense.identity(this.L.rows()))));
        }
        catch (IllegalArgumentException exc) {
            buf.append(unknown + exc.getMessage());
        }
        return buf.toString();
    }
}

