/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo;

import cern.colt.Partitioning;
import cern.colt.Swapper;
import cern.colt.function.tint.IntComparator;
import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;

public class FloatPartitioning {
    protected FloatPartitioning() {
    }

    public static void partition(FloatMatrix2D matrix, int[] rowIndexes, int rowFrom, int rowTo, int column, final float[] splitters, int splitFrom, int splitTo, int[] splitIndexes) {
        if (rowFrom < 0 || rowTo >= matrix.rows() || rowTo >= rowIndexes.length) {
            throw new IllegalArgumentException();
        }
        if (column < 0 || column >= matrix.columns()) {
            throw new IllegalArgumentException();
        }
        if (splitFrom < 0 || splitTo >= splitters.length) {
            throw new IllegalArgumentException();
        }
        if (splitIndexes.length < splitters.length) {
            throw new IllegalArgumentException();
        }
        final int[] g = rowIndexes;
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int b, int c) {
                int tmp = g[b];
                g[b] = g[c];
                g[c] = tmp;
            }
        };
        final FloatMatrix1D columnView = matrix.viewColumn(column);
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                float av = splitters[a];
                float bv = columnView.getQuick(g[b]);
                return av < bv ? -1 : (av == bv ? 0 : 1);
            }
        };
        IntComparator comp2 = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                float bv;
                float av = columnView.getQuick(g[a]);
                return av < (bv = columnView.getQuick(g[b])) ? -1 : (av == bv ? 0 : 1);
            }
        };
        IntComparator comp3 = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                float av = splitters[a];
                float bv = splitters[b];
                return av < bv ? -1 : (av == bv ? 0 : 1);
            }
        };
        Partitioning.genericPartition(rowFrom, rowTo, splitFrom, splitTo, splitIndexes, comp, comp2, comp3, swapper);
    }

    public static FloatMatrix2D partition(FloatMatrix2D matrix, int column, float[] splitters, int[] splitIndexes) {
        int rowFrom = 0;
        int rowTo = matrix.rows() - 1;
        int splitFrom = 0;
        int splitTo = splitters.length - 1;
        int[] rowIndexes = new int[matrix.rows()];
        int i = rowIndexes.length;
        while (--i >= 0) {
            rowIndexes[i] = i;
        }
        FloatPartitioning.partition(matrix, rowIndexes, rowFrom, rowTo, column, splitters, splitFrom, splitTo, splitIndexes);
        int[] columnIndexes = new int[matrix.columns()];
        int i2 = columnIndexes.length;
        while (--i2 >= 0) {
            columnIndexes[i2] = i2;
        }
        return matrix.viewSelection(rowIndexes, columnIndexes);
    }
}

