/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfcomplex;

import cern.colt.PersistentObject;
import cern.colt.matrix.tfcomplex.FComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.DenseFComplexMatrix1D;
import cern.colt.matrix.tfcomplex.impl.SparseFComplexMatrix1D;
import cern.jet.math.tfcomplex.FComplexFunctions;
import cern.jet.random.tfloat.engine.FloatMersenneTwister;
import cern.jet.random.tfloat.sampling.FloatRandomSamplingAssistant;
import java.util.ArrayList;

public class FComplexFactory1D
extends PersistentObject {
    private static final long serialVersionUID = 1L;
    public static final FComplexFactory1D dense = new FComplexFactory1D();
    public static final FComplexFactory1D sparse = new FComplexFactory1D();

    protected FComplexFactory1D() {
    }

    public FComplexMatrix1D append(FComplexMatrix1D A, FComplexMatrix1D B) {
        FComplexMatrix1D matrix = this.make((int)(A.size() + B.size()));
        matrix.viewPart(0, (int)A.size()).assign(A);
        matrix.viewPart((int)A.size(), (int)B.size()).assign(B);
        return matrix;
    }

    public FComplexMatrix1D make(float[] values) {
        if (this == sparse) {
            return new SparseFComplexMatrix1D(values);
        }
        return new DenseFComplexMatrix1D(values);
    }

    public FComplexMatrix1D make(FComplexMatrix1D[] parts) {
        if (parts.length == 0) {
            return this.make(0);
        }
        int size = 0;
        for (int i = 0; i < parts.length; ++i) {
            size = (int)((long)size + parts[i].size());
        }
        FComplexMatrix1D vector = this.make(size);
        size = 0;
        for (int i = 0; i < parts.length; ++i) {
            vector.viewPart(size, (int)parts[i].size()).assign(parts[i]);
            size = (int)((long)size + parts[i].size());
        }
        return vector;
    }

    public FComplexMatrix1D make(int size) {
        if (this == sparse) {
            return new SparseFComplexMatrix1D(size);
        }
        return new DenseFComplexMatrix1D(size);
    }

    public FComplexMatrix1D make(int size, float[] initialValue) {
        return this.make(size).assign(initialValue);
    }

    public FComplexMatrix1D make(ArrayList<float[]> values) {
        int size = values.size();
        FComplexMatrix1D vector = this.make(size);
        for (int i = 0; i < size; ++i) {
            vector.setQuick(i, values.get(i));
        }
        return vector;
    }

    public FComplexMatrix1D random(int size) {
        return this.make(size).assign(FComplexFunctions.random());
    }

    public FComplexMatrix1D repeat(FComplexMatrix1D A, int repeat) {
        int size = (int)A.size();
        FComplexMatrix1D matrix = this.make(repeat * size);
        for (int i = 0; i < repeat; ++i) {
            matrix.viewPart(size * i, size).assign(A);
        }
        return matrix;
    }

    public FComplexMatrix1D sample(int size, float[] value, float nonZeroFraction) {
        float epsilon = 1.0E-5f;
        if (nonZeroFraction < 0.0f - epsilon || nonZeroFraction > 1.0f + epsilon) {
            throw new IllegalArgumentException();
        }
        if (nonZeroFraction < 0.0f) {
            nonZeroFraction = 0.0f;
        }
        if (nonZeroFraction > 1.0f) {
            nonZeroFraction = 1.0f;
        }
        FComplexMatrix1D matrix = this.make(size);
        int n = Math.round((float)size * nonZeroFraction);
        if (n == 0) {
            return matrix;
        }
        FloatRandomSamplingAssistant sampler = new FloatRandomSamplingAssistant(n, size, new FloatMersenneTwister());
        for (int i = 0; i < size; ++i) {
            if (!sampler.sampleNextElement()) continue;
            matrix.setQuick(i, value);
        }
        return matrix;
    }

    public ArrayList<float[]> toList(FComplexMatrix1D values) {
        int size = (int)values.size();
        ArrayList<float[]> list = new ArrayList<float[]>(size);
        for (int i = 0; i < size; ++i) {
            list.set(i, values.getQuick(i));
        }
        return list;
    }
}

