/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver.preconditioner;

import cern.colt.matrix.Norm;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.DenseDoubleAlgebra;
import cern.colt.matrix.tdouble.algo.DoubleProperty;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoublePreconditioner;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseDoubleMatrix1D;
import cern.colt.matrix.tdouble.impl.SparseRCMDoubleMatrix2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class DoubleILUT
implements DoublePreconditioner {
    private SparseRCMDoubleMatrix2D LU;
    private final DoubleMatrix1D y;
    private final double tau;
    private final List<IntDoubleEntry> lower;
    private final List<IntDoubleEntry> upper;
    private final int p;
    private final int n;

    public DoubleILUT(int n, double tau, int p) {
        this.n = n;
        this.tau = tau;
        this.p = p;
        this.lower = new ArrayList<IntDoubleEntry>(n);
        this.upper = new ArrayList<IntDoubleEntry>(n);
        this.y = new DenseDoubleMatrix1D(n);
    }

    public DoubleILUT(int n) {
        this(n, 1.0E-6, 25);
    }

    @Override
    public DoubleMatrix1D apply(DoubleMatrix1D b, DoubleMatrix1D x) {
        if (x == null) {
            x = b.like();
        }
        this.unitLowerSolve(b, this.y);
        return this.upperSolve(this.y, x);
    }

    @Override
    public DoubleMatrix1D transApply(DoubleMatrix1D b, DoubleMatrix1D x) {
        if (x == null) {
            x = b.like();
        }
        this.upperTransSolve(b, this.y);
        return this.unitLowerTransSolve(this.y, x);
    }

    @Override
    public void setMatrix(DoubleMatrix2D A) {
        DoubleProperty.DEFAULT.isSquare(A);
        if (A.rows() != this.n) {
            throw new IllegalArgumentException("A.rows() != n");
        }
        this.LU = new SparseRCMDoubleMatrix2D(this.n, this.n);
        this.LU.assign(A);
        this.LU.trimToSize();
        this.factor();
    }

    private void factor() {
        int n = this.LU.rows();
        for (int i = 1; i < n; ++i) {
            SparseDoubleMatrix1D rowi = this.LU.viewRow(i);
            double taui = DenseDoubleAlgebra.DEFAULT.norm(rowi, Norm.Two) * this.tau;
            for (int k = 0; k < i; ++k) {
                SparseDoubleMatrix1D rowk = this.LU.viewRow(k);
                if (rowk.getQuick(k) == 0.0) {
                    throw new RuntimeException("Zero diagonal entry on row " + (k + 1) + " during ILU process");
                }
                double LUik = rowi.getQuick(k) / rowk.getQuick(k);
                if (Math.abs(LUik) <= taui) continue;
                int rowUsed = (int)rowk.size();
                for (int j = k + 1; j < rowUsed; ++j) {
                    rowi.setQuick(j, rowi.getQuick(j) - LUik * rowk.getQuick(j));
                }
                rowi.setQuick(k, LUik);
            }
            this.gather(rowi, taui, i);
        }
    }

    private void gather(SparseDoubleMatrix1D v, double taui, int d) {
        IntDoubleEntry e;
        int i;
        int nl = 0;
        int nu = 0;
        long[] indexes = v.elements().keys().elements();
        for (int i2 = 0; i2 < indexes.length; ++i2) {
            if (indexes[i2] < (long)d) {
                ++nl;
                continue;
            }
            if (indexes[i2] <= (long)d) continue;
            ++nu;
        }
        double[] z = v.toArray();
        v.assign(0.0);
        this.lower.clear();
        for (i = 0; i < d; ++i) {
            if (!(Math.abs(z[i]) > taui)) continue;
            this.lower.add(new IntDoubleEntry(i, z[i]));
        }
        this.upper.clear();
        for (i = d + 1; i < z.length; ++i) {
            if (!(Math.abs(z[i]) > taui)) continue;
            this.upper.add(new IntDoubleEntry(i, z[i]));
        }
        Collections.sort(this.lower);
        Collections.sort(this.upper);
        v.setQuick(d, z[d]);
        for (i = 0; i < Math.min(nl + this.p, this.lower.size()); ++i) {
            e = this.lower.get(i);
            v.setQuick(e.index, e.value);
        }
        for (i = 0; i < Math.min(nu + this.p, this.upper.size()); ++i) {
            e = this.upper.get(i);
            v.setQuick(e.index, e.value);
        }
    }

    private DoubleMatrix1D unitLowerSolve(DoubleMatrix1D b, DoubleMatrix1D x) {
        double[] bd = ((DenseDoubleMatrix1D)b).elements();
        double[] xd = ((DenseDoubleMatrix1D)x).elements();
        int rows = this.LU.rows();
        for (int i = 0; i < rows; ++i) {
            SparseDoubleMatrix1D row = this.LU.viewRow(i);
            double sum = 0.0;
            for (int j = 0; j < i; ++j) {
                sum += row.getQuick(j) * xd[j];
            }
            xd[i] = bd[i] - sum;
        }
        return x;
    }

    private DoubleMatrix1D unitLowerTransSolve(DoubleMatrix1D b, DoubleMatrix1D x) {
        x.assign(b);
        double[] xd = ((DenseDoubleMatrix1D)x).elements();
        int rows = this.LU.rows();
        for (int i = rows - 1; i >= 0; --i) {
            SparseDoubleMatrix1D row = this.LU.viewRow(i);
            for (int j = 0; j < i; ++j) {
                int n = j;
                xd[n] = xd[n] - row.getQuick(j) * xd[i];
            }
        }
        return x;
    }

    private DoubleMatrix1D upperSolve(DoubleMatrix1D b, DoubleMatrix1D x) {
        double[] bd = ((DenseDoubleMatrix1D)b).elements();
        double[] xd = ((DenseDoubleMatrix1D)x).elements();
        int rows = this.LU.rows();
        for (int i = rows - 1; i >= 0; --i) {
            SparseDoubleMatrix1D row = this.LU.viewRow(i);
            int used = (int)row.size();
            double sum = 0.0;
            for (int j = i + 1; j < used; ++j) {
                sum += row.getQuick(j) * xd[j];
            }
            xd[i] = (bd[i] - sum) / row.getQuick(i);
        }
        return x;
    }

    private DoubleMatrix1D upperTransSolve(DoubleMatrix1D b, DoubleMatrix1D x) {
        x.assign(b);
        double[] xd = ((DenseDoubleMatrix1D)x).elements();
        int rows = this.LU.rows();
        for (int i = 0; i < rows; ++i) {
            SparseDoubleMatrix1D row = this.LU.viewRow(i);
            int used = (int)row.size();
            int n = i;
            xd[n] = xd[n] / row.getQuick(i);
            for (int j = i + 1; j < used; ++j) {
                int n2 = j;
                xd[n2] = xd[n2] - row.getQuick(j) * xd[i];
            }
        }
        return x;
    }

    private static class IntDoubleEntry
    implements Comparable<IntDoubleEntry> {
        public int index;
        public double value;

        public IntDoubleEntry(int index, double value) {
            this.index = index;
            this.value = value;
        }

        @Override
        public int compareTo(IntDoubleEntry o) {
            if (Math.abs(this.value) < Math.abs(o.value)) {
                return 1;
            }
            if (Math.abs(this.value) == Math.abs(o.value)) {
                return 0;
            }
            return -1;
        }

        public String toString() {
            return "(" + this.index + "=" + this.value + ")";
        }
    }
}

