/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.algo.solver.AbstractDoubleIterationMonitor;
import cern.colt.matrix.tdouble.algo.solver.DoubleNotConvergedException;
import cern.colt.matrix.tdouble.algo.solver.IterativeSolverDoubleNotConvergedException;

public class DefaultDoubleIterationMonitor
extends AbstractDoubleIterationMonitor {
    double initR;
    double rtol;
    double atol;
    double dtol;
    int maxIter;

    public DefaultDoubleIterationMonitor(int maxIter, double rtol, double atol, double dtol) {
        this.maxIter = maxIter;
        this.rtol = rtol;
        this.atol = atol;
        this.dtol = dtol;
    }

    public DefaultDoubleIterationMonitor() {
        this.maxIter = 100000;
        this.rtol = 1.0E-5;
        this.atol = 1.0E-50;
        this.dtol = 100000.0;
    }

    @Override
    public void setMaxIterations(int maxIter) {
        this.maxIter = maxIter;
    }

    @Override
    public int getMaxIterations() {
        return this.maxIter;
    }

    public void setRelativeTolerance(double rtol) {
        this.rtol = rtol;
    }

    public double getRelativeTolerance() {
        return this.rtol;
    }

    public void setAbsoluteTolerance(double atol) {
        this.atol = atol;
    }

    public double getAbsoluteTolerance() {
        return this.atol;
    }

    public void setDivergenceTolerance(double dtol) {
        this.dtol = dtol;
    }

    public double getDivergenceTolerance() {
        return this.dtol;
    }

    @Override
    protected boolean convergedI(double r) throws IterativeSolverDoubleNotConvergedException {
        if (this.isFirst()) {
            this.initR = r;
        }
        if (r < Math.max(this.rtol * this.initR, this.atol)) {
            return true;
        }
        if (r > this.dtol * this.initR) {
            throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Divergence, this);
        }
        if (this.iter >= this.maxIter) {
            throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Iterations, this);
        }
        if (Double.isNaN(r)) {
            throw new IterativeSolverDoubleNotConvergedException(DoubleNotConvergedException.Reason.Divergence, this);
        }
        return false;
    }

    @Override
    protected boolean convergedI(double r, DoubleMatrix1D x) throws IterativeSolverDoubleNotConvergedException {
        return this.convergedI(r);
    }
}

