/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo.solver;

import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.algo.solver.DefaultDoubleIterationMonitor;
import cern.colt.matrix.tdouble.algo.solver.DoubleIterationMonitor;
import cern.colt.matrix.tdouble.algo.solver.DoubleIterativeSolver;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoubleIdentity;
import cern.colt.matrix.tdouble.algo.solver.preconditioner.DoublePreconditioner;

public abstract class AbstractDoubleIterativeSolver
implements DoubleIterativeSolver {
    protected DoublePreconditioner M = new DoubleIdentity();
    protected DoubleIterationMonitor iter = new DefaultDoubleIterationMonitor();

    @Override
    public void setPreconditioner(DoublePreconditioner M) {
        this.M = M;
    }

    @Override
    public DoublePreconditioner getPreconditioner() {
        return this.M;
    }

    @Override
    public DoubleIterationMonitor getIterationMonitor() {
        return this.iter;
    }

    @Override
    public void setIterationMonitor(DoubleIterationMonitor iter) {
        this.iter = iter;
    }

    protected void checkSizes(DoubleMatrix2D A, DoubleMatrix1D b, DoubleMatrix1D x) {
        if (A.rows() != A.columns()) {
            throw new IllegalArgumentException("A is not square");
        }
        if (b.size() != (long)A.rows()) {
            throw new IllegalArgumentException("b.size() != A.rows()");
        }
        if (b.size() != x.size()) {
            throw new IllegalArgumentException("b.size() != x.size()");
        }
    }
}

