/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.algo;

import cern.colt.Timer;
import cern.colt.function.tdouble.DoubleDoubleFunction;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.matrix.tdouble.DoubleFactory1D;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.DoubleMatrix3D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.jet.math.tdouble.DoubleFunctions;
import cern.jet.random.tdouble.engine.DoubleMersenneTwister;
import cern.jet.random.tdouble.engine.DoubleRandomEngine;
import cern.jet.random.tdouble.sampling.DoubleRandomSampler;
import cern.jet.stat.tdouble.DoubleDescriptive;
import edu.emory.utils.ConcurrencyUtils;
import hep.aida.tdouble.DoubleIHistogram1D;
import hep.aida.tdouble.DoubleIHistogram2D;
import hep.aida.tdouble.DoubleIHistogram3D;
import hep.aida.tdouble.bin.DoubleBinFunction1D;
import hep.aida.tdouble.bin.DynamicDoubleBin1D;
import hep.aida.tdouble.ref.DoubleHistogram2D;
import hep.aida.tdouble.ref.DoubleHistogram3D;
import hep.aida.tdouble.ref.DoubleVariableAxis;
import java.util.concurrent.Future;

public class DoubleStatistic {
    private static final DoubleFunctions F = DoubleFunctions.functions;
    public static final VectorVectorFunction EUCLID = new VectorVectorFunction(){

        @Override
        public final double apply(DoubleMatrix1D a, DoubleMatrix1D b) {
            return Math.sqrt(a.aggregate(b, DoubleFunctions.plus, DoubleFunctions.chain(DoubleFunctions.square, DoubleFunctions.minus)));
        }
    };
    public static final VectorVectorFunction BRAY_CURTIS = new VectorVectorFunction(){

        @Override
        public final double apply(DoubleMatrix1D a, DoubleMatrix1D b) {
            return a.aggregate(b, DoubleFunctions.plus, DoubleFunctions.chain(DoubleFunctions.abs, DoubleFunctions.minus)) / a.aggregate(b, DoubleFunctions.plus, DoubleFunctions.plus);
        }
    };
    public static final VectorVectorFunction CANBERRA = new VectorVectorFunction(){
        DoubleDoubleFunction fun = new DoubleDoubleFunction(){

            @Override
            public final double apply(double a, double b) {
                return Math.abs(a - b) / Math.abs(a + b);
            }
        };

        @Override
        public final double apply(DoubleMatrix1D a, DoubleMatrix1D b) {
            return a.aggregate(b, DoubleFunctions.plus, this.fun);
        }
    };
    public static final VectorVectorFunction MAXIMUM = new VectorVectorFunction(){

        @Override
        public final double apply(DoubleMatrix1D a, DoubleMatrix1D b) {
            return a.aggregate(b, DoubleFunctions.max, DoubleFunctions.chain(DoubleFunctions.abs, DoubleFunctions.minus));
        }
    };
    public static final VectorVectorFunction MANHATTAN = new VectorVectorFunction(){

        @Override
        public final double apply(DoubleMatrix1D a, DoubleMatrix1D b) {
            return a.aggregate(b, DoubleFunctions.plus, DoubleFunctions.chain(DoubleFunctions.abs, DoubleFunctions.minus));
        }
    };

    protected DoubleStatistic() {
    }

    public static DoubleMatrix2D aggregate(DoubleMatrix2D matrix, DoubleBinFunction1D[] aggr, DoubleMatrix2D result) {
        DynamicDoubleBin1D bin = new DynamicDoubleBin1D();
        double[] elements = new double[matrix.rows()];
        DoubleArrayList values = new DoubleArrayList(elements);
        int column = matrix.columns();
        while (--column >= 0) {
            matrix.viewColumn(column).toArray(elements);
            bin.clear();
            bin.addAllOf(values);
            int i = aggr.length;
            while (--i >= 0) {
                result.set(i, column, aggr[i].apply(bin));
            }
        }
        return result;
    }

    public static DynamicDoubleBin1D bin(DoubleMatrix1D vector) {
        DynamicDoubleBin1D bin = new DynamicDoubleBin1D();
        bin.addAllOf(DoubleFactory1D.dense.toList(vector));
        return bin;
    }

    public static DoubleMatrix2D correlation(DoubleMatrix2D covariance) {
        int i = covariance.columns();
        while (--i >= 0) {
            int j = i;
            while (--j >= 0) {
                double stdDev1 = Math.sqrt(covariance.getQuick(i, i));
                double stdDev2 = Math.sqrt(covariance.getQuick(j, j));
                double cov = covariance.getQuick(i, j);
                double corr = cov / (stdDev1 * stdDev2);
                covariance.setQuick(i, j, corr);
                covariance.setQuick(j, i, corr);
            }
        }
        i = covariance.columns();
        while (--i >= 0) {
            covariance.setQuick(i, i, 1.0);
        }
        return covariance;
    }

    public static DoubleMatrix2D covariance(DoubleMatrix2D matrix) {
        int rows = matrix.rows();
        int columns = matrix.columns();
        DenseDoubleMatrix2D covariance = new DenseDoubleMatrix2D(columns, columns);
        double[] sums = new double[columns];
        DoubleMatrix1D[] cols = new DoubleMatrix1D[columns];
        int i = columns;
        while (--i >= 0) {
            cols[i] = matrix.viewColumn(i);
            sums[i] = cols[i].zSum();
        }
        i = columns;
        while (--i >= 0) {
            int j = i + 1;
            while (--j >= 0) {
                double sumOfProducts = cols[i].zDotProduct(cols[j]);
                double cov = (sumOfProducts - sums[i] * sums[j] / (double)rows) / (double)rows;
                ((DoubleMatrix2D)covariance).setQuick(i, j, cov);
                ((DoubleMatrix2D)covariance).setQuick(j, i, cov);
            }
        }
        return covariance;
    }

    public static DoubleIHistogram2D cube(DoubleMatrix1D x, DoubleMatrix1D y, DoubleMatrix1D weights) {
        if (x.size() != y.size() || y.size() != weights.size()) {
            throw new IllegalArgumentException("vectors must have same size");
        }
        double epsilon = 1.0E-5f;
        DoubleArrayList distinct = new DoubleArrayList();
        double[] vals = new double[(int)x.size()];
        DoubleArrayList sorted = new DoubleArrayList(vals);
        x.toArray(vals);
        sorted.sort();
        DoubleDescriptive.frequencies(sorted, distinct, null);
        if (distinct.size() > 0) {
            distinct.add(distinct.get(distinct.size() - 1) + epsilon);
        }
        distinct.trimToSize();
        DoubleVariableAxis xaxis = new DoubleVariableAxis(distinct.elements());
        y.toArray(vals);
        sorted.sort();
        DoubleDescriptive.frequencies(sorted, distinct, null);
        if (distinct.size() > 0) {
            distinct.add(distinct.get(distinct.size() - 1) + epsilon);
        }
        distinct.trimToSize();
        DoubleVariableAxis yaxis = new DoubleVariableAxis(distinct.elements());
        DoubleHistogram2D histo = new DoubleHistogram2D("Cube", xaxis, yaxis);
        return DoubleStatistic.histogram(histo, x, y, weights);
    }

    public static DoubleIHistogram3D cube(DoubleMatrix1D x, DoubleMatrix1D y, DoubleMatrix1D z, DoubleMatrix1D weights) {
        if (x.size() != y.size() || x.size() != z.size() || x.size() != weights.size()) {
            throw new IllegalArgumentException("vectors must have same size");
        }
        double epsilon = 1.0E-5f;
        DoubleArrayList distinct = new DoubleArrayList();
        double[] vals = new double[(int)x.size()];
        DoubleArrayList sorted = new DoubleArrayList(vals);
        x.toArray(vals);
        sorted.sort();
        DoubleDescriptive.frequencies(sorted, distinct, null);
        if (distinct.size() > 0) {
            distinct.add(distinct.get(distinct.size() - 1) + epsilon);
        }
        distinct.trimToSize();
        DoubleVariableAxis xaxis = new DoubleVariableAxis(distinct.elements());
        y.toArray(vals);
        sorted.sort();
        DoubleDescriptive.frequencies(sorted, distinct, null);
        if (distinct.size() > 0) {
            distinct.add(distinct.get(distinct.size() - 1) + epsilon);
        }
        distinct.trimToSize();
        DoubleVariableAxis yaxis = new DoubleVariableAxis(distinct.elements());
        z.toArray(vals);
        sorted.sort();
        DoubleDescriptive.frequencies(sorted, distinct, null);
        if (distinct.size() > 0) {
            distinct.add(distinct.get(distinct.size() - 1) + epsilon);
        }
        distinct.trimToSize();
        DoubleVariableAxis zaxis = new DoubleVariableAxis(distinct.elements());
        DoubleHistogram3D histo = new DoubleHistogram3D("Cube", xaxis, yaxis, zaxis);
        return DoubleStatistic.histogram(histo, x, y, z, weights);
    }

    public static void demo1() {
        double[][] values = new double[][]{{1.0, 2.0, 3.0}, {2.0, 4.0, 6.0}, {3.0, 6.0, 9.0}, {4.0, -8.0, -10.0}};
        DoubleFactory2D factory = DoubleFactory2D.dense;
        DoubleMatrix2D A = factory.make(values);
        System.out.println("\n\nmatrix=" + A);
        System.out.println("\ncovar1=" + DoubleStatistic.covariance(A));
    }

    public static void demo2(int rows, int columns, boolean print) {
        System.out.println("\n\ninitializing...");
        DoubleFactory2D factory = DoubleFactory2D.dense;
        DoubleMatrix2D A = factory.ascending(rows, columns);
        System.out.println("benchmarking correlation...");
        Timer timer = new Timer().start();
        DoubleMatrix2D corr = DoubleStatistic.correlation(DoubleStatistic.covariance(A));
        timer.stop().display();
        if (print) {
            System.out.println("printing result...");
            System.out.println(corr);
        }
        System.out.println("done.");
    }

    public static void demo3(VectorVectorFunction norm) {
        double[][] values = new double[][]{{-0.961105227470398, -0.2542109489440918}, {0.4308269f, -0.6993264555931091}, {-1.20710289478302, 0.6203059554100037}, {1.5345165729522705, 0.02135884016752243}, {-1.134154200553894, 0.2038843035697937}};
        System.out.println("\n\ninitializing...");
        DoubleFactory2D factory = DoubleFactory2D.dense;
        DoubleMatrix2D A = factory.make(values).viewDice();
        System.out.println("\nA=" + A.viewDice());
        System.out.println("\ndist=" + DoubleStatistic.distance(A, norm).viewDice());
    }

    public static DoubleMatrix2D distance(DoubleMatrix2D matrix, VectorVectorFunction distanceFunction) {
        int columns = matrix.columns();
        DenseDoubleMatrix2D distance = new DenseDoubleMatrix2D(columns, columns);
        DoubleMatrix1D[] cols = new DoubleMatrix1D[columns];
        int i = columns;
        while (--i >= 0) {
            cols[i] = matrix.viewColumn(i);
        }
        i = columns;
        while (--i >= 0) {
            int j = i;
            while (--j >= 0) {
                double d = distanceFunction.apply(cols[i], cols[j]);
                ((DoubleMatrix2D)distance).setQuick(i, j, d);
                ((DoubleMatrix2D)distance).setQuick(j, i, d);
            }
        }
        return distance;
    }

    public static DoubleIHistogram1D histogram(DoubleIHistogram1D histo, DoubleMatrix1D vector) {
        int i = (int)vector.size();
        while (--i >= 0) {
            histo.fill(vector.getQuick(i));
        }
        return histo;
    }

    public static DoubleIHistogram1D histogram(DoubleIHistogram1D histo, DoubleMatrix2D matrix) {
        histo.fill_2D((double[])matrix.elements(), matrix.rows(), matrix.columns(), (int)matrix.index(0, 0), matrix.rowStride(), matrix.columnStride());
        return histo;
    }

    public static DoubleIHistogram1D[][] histogram(final DoubleIHistogram1D[][] histo, final DoubleMatrix2D matrix, int m, final int n) {
        int rows = matrix.rows();
        int columns = matrix.columns();
        if (m >= rows) {
            throw new IllegalArgumentException("Parameter m must be smaller than the number of rows in the matrix");
        }
        if (n >= columns) {
            throw new IllegalArgumentException("Parameter n must be smaller than the number of columns in the matrix");
        }
        final int row_size = rows / m;
        final int col_size = columns / n;
        final int[] height = new int[m];
        final int[] width = new int[n];
        for (int r = 0; r < m - 1; ++r) {
            height[r] = row_size;
        }
        height[m - 1] = rows - (m - 1) * row_size;
        for (int c = 0; c < n - 1; ++c) {
            width[c] = col_size;
        }
        width[n - 1] = columns - (n - 1) * col_size;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && rows * columns >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            nthreads = Math.min(nthreads, m);
            Future[] futures = new Future[nthreads];
            int k = m / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstRow = j * k;
                final int lastRow = j == nthreads - 1 ? m : firstRow + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        DoubleMatrix2D view = null;
                        for (int r = firstRow; r < lastRow; ++r) {
                            for (int c = 0; c < n; ++c) {
                                view = matrix.viewPart(r * row_size, c * col_size, height[r], width[c]);
                                histo[r][c].fill_2D((double[])view.elements(), view.rows(), view.columns(), (int)view.index(0, 0), view.rowStride(), view.columnStride());
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            DoubleMatrix2D view = null;
            for (int r = 0; r < m; ++r) {
                for (int c = 0; c < n; ++c) {
                    view = matrix.viewPart(r * row_size, c * col_size, height[r], width[c]);
                    histo[r][c].fill_2D((double[])view.elements(), view.rows(), view.columns(), (int)view.index(0, 0), view.rowStride(), view.columnStride());
                }
            }
        }
        return histo;
    }

    public static DoubleIHistogram2D histogram(DoubleIHistogram2D histo, DoubleMatrix1D x, DoubleMatrix1D y) {
        if (x.size() != y.size()) {
            throw new IllegalArgumentException("vectors must have same size");
        }
        int i = (int)x.size();
        while (--i >= 0) {
            histo.fill(x.getQuick(i), y.getQuick(i));
        }
        return histo;
    }

    public static DoubleIHistogram2D histogram(DoubleIHistogram2D histo, DoubleMatrix1D x, DoubleMatrix1D y, DoubleMatrix1D weights) {
        if (x.size() != y.size() || y.size() != weights.size()) {
            throw new IllegalArgumentException("vectors must have same size");
        }
        int i = (int)x.size();
        while (--i >= 0) {
            histo.fill(x.getQuick(i), y.getQuick(i), weights.getQuick(i));
        }
        return histo;
    }

    public static DoubleIHistogram3D histogram(DoubleIHistogram3D histo, DoubleMatrix1D x, DoubleMatrix1D y, DoubleMatrix1D z, DoubleMatrix1D weights) {
        if (x.size() != y.size() || x.size() != z.size() || x.size() != weights.size()) {
            throw new IllegalArgumentException("vectors must have same size");
        }
        int i = (int)x.size();
        while (--i >= 0) {
            histo.fill(x.getQuick(i), y.getQuick(i), z.getQuick(i), weights.getQuick(i));
        }
        return histo;
    }

    public static void main(String[] args) {
        int rows = Integer.parseInt(args[0]);
        int columns = Integer.parseInt(args[1]);
        boolean print = args[2].equals("print");
        DoubleStatistic.demo2(rows, columns, print);
    }

    public static DoubleMatrix1D viewSample(DoubleMatrix1D matrix, double fraction, DoubleRandomEngine randomGenerator) {
        int ncolumns;
        double epsilon = 1.0E-5f;
        if (fraction < 0.0 - epsilon || fraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (fraction < 0.0) {
            fraction = 0.0;
        }
        if (fraction > 1.0) {
            fraction = 1.0;
        }
        if (randomGenerator == null) {
            randomGenerator = new DoubleMersenneTwister((int)System.currentTimeMillis());
        }
        int max = ncolumns = (int)Math.round((double)matrix.size() * fraction);
        long[] selected = new long[max];
        int n = ncolumns;
        int N = (int)matrix.size();
        DoubleRandomSampler.sample(n, N, n, 0L, selected, 0, randomGenerator);
        int[] selectedCols = new int[n];
        for (int i = 0; i < n; ++i) {
            selectedCols[i] = (int)selected[i];
        }
        return matrix.viewSelection(selectedCols);
    }

    public static DoubleMatrix2D viewSample(DoubleMatrix2D matrix, double rowFraction, double columnFraction, DoubleRandomEngine randomGenerator) {
        double epsilon = 1.0E-5f;
        if (rowFraction < 0.0 - epsilon || rowFraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (rowFraction < 0.0) {
            rowFraction = 0.0;
        }
        if (rowFraction > 1.0) {
            rowFraction = 1.0;
        }
        if (columnFraction < 0.0 - epsilon || columnFraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (columnFraction < 0.0) {
            columnFraction = 0.0;
        }
        if (columnFraction > 1.0) {
            columnFraction = 1.0;
        }
        if (randomGenerator == null) {
            randomGenerator = new DoubleMersenneTwister((int)System.currentTimeMillis());
        }
        int nrows = (int)Math.round((double)matrix.rows() * rowFraction);
        int ncolumns = (int)Math.round((double)matrix.columns() * columnFraction);
        int max = Math.max(nrows, ncolumns);
        long[] selected = new long[max];
        int n = nrows;
        int N = matrix.rows();
        DoubleRandomSampler.sample(n, N, n, 0L, selected, 0, randomGenerator);
        int[] selectedRows = new int[n];
        for (int i = 0; i < n; ++i) {
            selectedRows[i] = (int)selected[i];
        }
        n = ncolumns;
        N = matrix.columns();
        DoubleRandomSampler.sample(n, N, n, 0L, selected, 0, randomGenerator);
        int[] selectedCols = new int[n];
        for (int i = 0; i < n; ++i) {
            selectedCols[i] = (int)selected[i];
        }
        return matrix.viewSelection(selectedRows, selectedCols);
    }

    public static DoubleMatrix3D viewSample(DoubleMatrix3D matrix, double sliceFraction, double rowFraction, double columnFraction, DoubleRandomEngine randomGenerator) {
        double epsilon = 1.0E-5f;
        if (sliceFraction < 0.0 - epsilon || sliceFraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (sliceFraction < 0.0) {
            sliceFraction = 0.0;
        }
        if (sliceFraction > 1.0) {
            sliceFraction = 1.0;
        }
        if (rowFraction < 0.0 - epsilon || rowFraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (rowFraction < 0.0) {
            rowFraction = 0.0;
        }
        if (rowFraction > 1.0) {
            rowFraction = 1.0;
        }
        if (columnFraction < 0.0 - epsilon || columnFraction > 1.0 + epsilon) {
            throw new IllegalArgumentException();
        }
        if (columnFraction < 0.0) {
            columnFraction = 0.0;
        }
        if (columnFraction > 1.0) {
            columnFraction = 1.0;
        }
        if (randomGenerator == null) {
            randomGenerator = new DoubleMersenneTwister((int)System.currentTimeMillis());
        }
        int nslices = (int)Math.round((double)matrix.slices() * sliceFraction);
        int nrows = (int)Math.round((double)matrix.rows() * rowFraction);
        int ncolumns = (int)Math.round((double)matrix.columns() * columnFraction);
        int max = Math.max(nslices, Math.max(nrows, ncolumns));
        long[] selected = new long[max];
        int n = nslices;
        int N = matrix.slices();
        DoubleRandomSampler.sample(n, N, n, 0L, selected, 0, randomGenerator);
        int[] selectedSlices = new int[n];
        for (int i = 0; i < n; ++i) {
            selectedSlices[i] = (int)selected[i];
        }
        n = nrows;
        N = matrix.rows();
        DoubleRandomSampler.sample(n, N, n, 0L, selected, 0, randomGenerator);
        int[] selectedRows = new int[n];
        for (int i = 0; i < n; ++i) {
            selectedRows[i] = (int)selected[i];
        }
        n = ncolumns;
        N = matrix.columns();
        DoubleRandomSampler.sample(n, N, n, 0L, selected, 0, randomGenerator);
        int[] selectedCols = new int[n];
        for (int i = 0; i < n; ++i) {
            selectedCols[i] = (int)selected[i];
        }
        return matrix.viewSelection(selectedSlices, selectedRows, selectedCols);
    }

    public static interface VectorVectorFunction {
        public double apply(DoubleMatrix1D var1, DoubleMatrix1D var2);
    }
}

