/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.impl.WrapperDComplexMatrix3D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_3D;
import edu.emory.utils.ConcurrencyUtils;
import java.util.concurrent.Future;

public class DenseLargeDComplexMatrix3D
extends WrapperDComplexMatrix3D {
    private static final long serialVersionUID = 1L;
    private double[][][] elements;
    private DoubleFFT_3D fft3;
    private DoubleFFT_2D fft2Slices;

    public DenseLargeDComplexMatrix3D(int slices, int rows, int columns) {
        block2: {
            super(null);
            try {
                this.setUp(slices, rows, columns);
            }
            catch (IllegalArgumentException exc) {
                if ("matrix too large".equals(exc.getMessage())) break block2;
                throw exc;
            }
        }
        this.elements = new double[slices][rows][2 * columns];
    }

    @Override
    public double[] getQuick(int slice, int row, int column) {
        return new double[]{this.elements[slice][row][2 * column], this.elements[slice][row][2 * column + 1]};
    }

    @Override
    public void setQuick(int slice, int row, int column, double[] value) {
        this.elements[slice][row][2 * column] = value[0];
        this.elements[slice][row][2 * column + 1] = value[1];
    }

    @Override
    public void setQuick(int slice, int row, int column, double re, double im) {
        this.elements[slice][row][2 * column] = re;
        this.elements[slice][row][2 * column + 1] = im;
    }

    @Override
    public void fft2Slices() {
        int nthreads;
        if (this.fft2Slices == null) {
            this.fft2Slices = new DoubleFFT_2D(this.rows, this.columns);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            ConcurrencyUtils.setThreadsBeginN_2D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            DenseLargeDComplexMatrix3D.this.fft2Slices.complexForward(DenseLargeDComplexMatrix3D.this.elements[s]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int s = 0; s < this.slices; ++s) {
                this.fft2Slices.complexForward(this.elements[s]);
            }
        }
    }

    @Override
    public void fft3() {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft3 == null) {
            this.fft3 = new DoubleFFT_3D(this.slices, this.rows, this.columns);
        }
        this.fft3.complexForward(this.elements);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    @Override
    public void ifft2Slices(final boolean scale) {
        int nthreads;
        if (this.fft2Slices == null) {
            this.fft2Slices = new DoubleFFT_2D(this.rows, this.columns);
        }
        if ((nthreads = ConcurrencyUtils.getNumberOfThreads()) > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_3D()) {
            ConcurrencyUtils.setThreadsBeginN_2D(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_2Threads(Integer.MAX_VALUE);
            ConcurrencyUtils.setThreadsBeginN_1D_FFT_4Threads(Integer.MAX_VALUE);
            nthreads = Math.min(nthreads, this.slices);
            Future[] futures = new Future[nthreads];
            int k = this.slices / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstSlice = j * k;
                final int lastSlice = j == nthreads - 1 ? this.slices : firstSlice + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int s = firstSlice; s < lastSlice; ++s) {
                            DenseLargeDComplexMatrix3D.this.fft2Slices.complexInverse(DenseLargeDComplexMatrix3D.this.elements[s], scale);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
            ConcurrencyUtils.resetThreadsBeginN();
            ConcurrencyUtils.resetThreadsBeginN_FFT();
        } else {
            for (int s = 0; s < this.slices; ++s) {
                this.fft2Slices.complexInverse(this.elements[s], scale);
            }
        }
    }

    @Override
    public void ifft3(boolean scale) {
        int oldNthreads = ConcurrencyUtils.getNumberOfThreads();
        ConcurrencyUtils.setNumberOfThreads(ConcurrencyUtils.nextPow2(oldNthreads));
        if (this.fft3 == null) {
            this.fft3 = new DoubleFFT_3D(this.slices, this.rows, this.columns);
        }
        this.fft3.complexInverse(this.elements, scale);
        ConcurrencyUtils.setNumberOfThreads(oldNthreads);
    }

    public double[][][] elements() {
        return this.elements;
    }

    @Override
    protected DComplexMatrix3D getContent() {
        return this;
    }

    @Override
    public DComplexMatrix3D like(int slices, int rows, int columns) {
        return new DenseLargeDComplexMatrix3D(slices, rows, columns);
    }
}

