/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex.impl;

import cern.colt.matrix.tdcomplex.DComplexMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;

class DelegateDComplexMatrix1D
extends DComplexMatrix1D {
    private static final long serialVersionUID = 1L;
    protected DComplexMatrix2D content;
    protected int row;

    public DelegateDComplexMatrix1D(DComplexMatrix2D newContent, int row) {
        if (row < 0 || row >= newContent.rows()) {
            throw new IllegalArgumentException();
        }
        this.setUp(newContent.columns());
        this.row = row;
        this.content = newContent;
    }

    @Override
    public synchronized double[] getQuick(int index) {
        return this.content.getQuick(this.row, index);
    }

    @Override
    public DComplexMatrix1D like(int size) {
        return this.content.like1D(size);
    }

    @Override
    public DComplexMatrix2D like2D(int rows, int columns) {
        return this.content.like(rows, columns);
    }

    @Override
    public synchronized void setQuick(int index, double[] value) {
        this.content.setQuick(this.row, index, value);
    }

    @Override
    public synchronized void setQuick(int index, double re, double im) {
        this.content.setQuick(this.row, index, re, im);
    }

    @Override
    public Object elements() {
        return this.content.elements();
    }

    @Override
    public DComplexMatrix2D reshape(int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    public DComplexMatrix3D reshape(int slices, int rows, int columns) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    protected DComplexMatrix1D viewSelectionLike(int[] offsets) {
        throw new IllegalArgumentException("This method is not supported.");
    }

    @Override
    public DoubleMatrix1D getImaginaryPart() {
        return this.content.viewRow(this.row).getImaginaryPart();
    }

    @Override
    public DoubleMatrix1D getRealPart() {
        return this.content.viewRow(this.row).getRealPart();
    }
}

