/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdcomplex;

import cern.colt.function.tdcomplex.DComplexDComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexDComplexFunction;
import cern.colt.function.tdcomplex.DComplexProcedure;
import cern.colt.function.tdcomplex.DComplexRealFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.tdcomplex.DComplexMatrix2D;
import cern.colt.matrix.tdcomplex.DComplexMatrix3D;
import cern.colt.matrix.tdcomplex.algo.DComplexProperty;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.jet.math.tdcomplex.DComplex;
import edu.emory.utils.ConcurrencyUtils;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class DComplexMatrix1D
extends AbstractMatrix1D {
    private static final long serialVersionUID = 1L;

    protected DComplexMatrix1D() {
    }

    public double[] aggregate(final DComplexDComplexDComplexFunction aggr, final DComplexDComplexFunction f) {
        double[] b = new double[2];
        int size = (int)this.size();
        if (size == 0) {
            b[0] = Double.NaN;
            b[1] = Double.NaN;
            return b;
        }
        double[] a = f.apply(this.getQuick(0));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double[] a = f.apply(DComplexMatrix1D.this.getQuick(firstIdx));
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            a = aggr.apply(a, f.apply(DComplexMatrix1D.this.getQuick(i)));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            for (int i = 1; i < size; ++i) {
                a = aggr.apply(a, f.apply(this.getQuick(i)));
            }
        }
        return a;
    }

    public double[] aggregate(final DComplexMatrix1D other, final DComplexDComplexDComplexFunction aggr, final DComplexDComplexDComplexFunction f) {
        this.checkSize(other);
        int size = (int)this.size();
        if (size == 0) {
            double[] b = new double[]{Double.NaN, Double.NaN};
            return b;
        }
        double[] a = f.apply(this.getQuick(0), other.getQuick(0));
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double[] a = f.apply(DComplexMatrix1D.this.getQuick(firstIdx), other.getQuick(firstIdx));
                        for (int i = firstIdx + 1; i < lastIdx; ++i) {
                            a = aggr.apply(a, f.apply(DComplexMatrix1D.this.getQuick(i), other.getQuick(i)));
                        }
                        return a;
                    }
                });
            }
            a = ConcurrencyUtils.waitForCompletion(futures, aggr);
        } else {
            for (int i = 1; i < size; ++i) {
                a = aggr.apply(a, f.apply(this.getQuick(i), other.getQuick(i)));
            }
        }
        return a;
    }

    public DComplexMatrix1D assign(final DComplexDComplexFunction f) {
        int size = (int)this.size();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            DComplexMatrix1D.this.setQuick(i, f.apply(DComplexMatrix1D.this.getQuick(i)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                this.setQuick(i, f.apply(this.getQuick(i)));
            }
        }
        return this;
    }

    public DComplexMatrix1D assign(final DComplexProcedure cond, final DComplexDComplexFunction f) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){
                    double[] elem;

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            this.elem = DComplexMatrix1D.this.getQuick(i);
                            if (!cond.apply(this.elem)) continue;
                            DComplexMatrix1D.this.setQuick(i, f.apply(this.elem));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                double[] elem = this.getQuick(i);
                if (!cond.apply(elem)) continue;
                this.setQuick(i, f.apply(elem));
            }
        }
        return this;
    }

    public DComplexMatrix1D assign(final DComplexProcedure cond, final double[] value) {
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){
                    double[] elem;

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            this.elem = DComplexMatrix1D.this.getQuick(i);
                            if (!cond.apply(this.elem)) continue;
                            DComplexMatrix1D.this.setQuick(i, value);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                double[] elem = this.getQuick(i);
                if (!cond.apply(elem)) continue;
                this.setQuick(i, value);
            }
        }
        return this;
    }

    public DComplexMatrix1D assign(final DComplexRealFunction f) {
        int size = (int)this.size();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            DComplexMatrix1D.this.setQuick(i, f.apply(DComplexMatrix1D.this.getQuick(i)), 0.0);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                this.setQuick(i, f.apply(this.getQuick(i)), 0.0);
            }
        }
        return this;
    }

    public DComplexMatrix1D assign(DComplexMatrix1D other) {
        if (other == this) {
            return this;
        }
        this.checkSize(other);
        final DComplexMatrix1D otherLoc = this.haveSharedCells(other) ? other.copy() : other;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            DComplexMatrix1D.this.setQuick(i, otherLoc.getQuick(i));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                this.setQuick(i, otherLoc.getQuick(i));
            }
        }
        return this;
    }

    public DComplexMatrix1D assign(final DComplexMatrix1D y, final DComplexDComplexDComplexFunction f) {
        int size = (int)this.size();
        this.checkSize(y);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            DComplexMatrix1D.this.setQuick(i, f.apply(DComplexMatrix1D.this.getQuick(i), y.getQuick(i)));
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                this.setQuick(i, f.apply(this.getQuick(i), y.getQuick(i)));
            }
        }
        return this;
    }

    public DComplexMatrix1D assign(final double re, final double im) {
        int size = (int)this.size();
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            DComplexMatrix1D.this.setQuick(i, re, im);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                this.setQuick(i, re, im);
            }
        }
        return this;
    }

    public DComplexMatrix1D assign(final double[] values) {
        int size = (int)this.size();
        if (values.length != 2 * size) {
            throw new IllegalArgumentException("The length of values[] must be equal to 2*size()=" + this.size());
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            DComplexMatrix1D.this.setQuick(i, values[2 * i], values[2 * i + 1]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                this.setQuick(i, values[2 * i], values[2 * i + 1]);
            }
        }
        return this;
    }

    public DComplexMatrix1D assignImaginary(final DoubleMatrix1D other) {
        this.checkSize(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            double re = DComplexMatrix1D.this.getQuick(i)[0];
                            double im = other.getQuick(i);
                            DComplexMatrix1D.this.setQuick(i, re, im);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                double re = this.getQuick(i)[0];
                double im = other.getQuick(i);
                this.setQuick(i, re, im);
            }
        }
        return this;
    }

    public DComplexMatrix1D assignReal(final DoubleMatrix1D other) {
        this.checkSize(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            int k = this.size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            double re = other.getQuick(i);
                            double im = DComplexMatrix1D.this.getQuick(i)[1];
                            DComplexMatrix1D.this.setQuick(i, re, im);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < this.size; ++i) {
                double re = other.getQuick(i);
                double im = this.getQuick(i)[1];
                this.setQuick(i, re, im);
            }
        }
        return this;
    }

    public int cardinality() {
        int size = (int)this.size();
        int cardinality = 0;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int j;
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            Integer[] results = new Integer[nthreads];
            int k = size / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int cardinality = 0;
                        double[] tmp = new double[2];
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            tmp = DComplexMatrix1D.this.getQuick(i);
                            if (tmp[0] == 0.0 && tmp[1] == 0.0) continue;
                            ++cardinality;
                        }
                        return cardinality;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (Integer)futures[j].get();
                }
                cardinality = results[0];
                for (j = 1; j < nthreads; ++j) {
                    cardinality += results[j].intValue();
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            double[] tmp = new double[2];
            for (int i = 0; i < size; ++i) {
                tmp = this.getQuick(i);
                if (tmp[0] == 0.0 && tmp[1] == 0.0) continue;
                ++cardinality;
            }
        }
        return cardinality;
    }

    public DComplexMatrix1D copy() {
        DComplexMatrix1D copy = this.like();
        copy.assign(this);
        return copy;
    }

    public boolean equals(double[] value) {
        return DComplexProperty.DEFAULT.equals(this, value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DComplexMatrix1D)) {
            return false;
        }
        return DComplexProperty.DEFAULT.equals(this, (DComplexMatrix1D)obj);
    }

    public double[] get(int index) {
        int size = (int)this.size();
        if (index < 0 || index >= size) {
            this.checkIndex(index);
        }
        return this.getQuick(index);
    }

    public abstract Object elements();

    public abstract DoubleMatrix1D getImaginaryPart();

    public void getNonZeros(IntArrayList indexList, ArrayList<double[]> valueList) {
        indexList.clear();
        valueList.clear();
        int s = (int)this.size();
        for (int i = 0; i < s; ++i) {
            double[] value = this.getQuick(i);
            if (value[0] == 0.0 && value[1] == 0.0) continue;
            indexList.add(i);
            valueList.add(value);
        }
    }

    public abstract double[] getQuick(int var1);

    public abstract DoubleMatrix1D getRealPart();

    public DComplexMatrix1D like() {
        int size = (int)this.size();
        return this.like(size);
    }

    public abstract DComplexMatrix1D like(int var1);

    public abstract DComplexMatrix2D like2D(int var1, int var2);

    public abstract DComplexMatrix2D reshape(int var1, int var2);

    public abstract DComplexMatrix3D reshape(int var1, int var2, int var3);

    public void set(int index, double re, double im) {
        int size = (int)this.size();
        if (index < 0 || index >= size) {
            this.checkIndex(index);
        }
        this.setQuick(index, re, im);
    }

    public void set(int index, double[] value) {
        int size = (int)this.size();
        if (index < 0 || index >= size) {
            this.checkIndex(index);
        }
        this.setQuick(index, value);
    }

    public abstract void setQuick(int var1, double var2, double var4);

    public abstract void setQuick(int var1, double[] var2);

    public void swap(final DComplexMatrix1D other) {
        int size = (int)this.size();
        this.checkSize(other);
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            double[] tmp = DComplexMatrix1D.this.getQuick(i);
                            DComplexMatrix1D.this.setQuick(i, other.getQuick(i));
                            other.setQuick(i, tmp);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                double[] tmp = this.getQuick(i);
                this.setQuick(i, other.getQuick(i));
                other.setQuick(i, tmp);
            }
        }
    }

    public double[] toArray() {
        int size = (int)this.size();
        double[] values = new double[2 * size];
        this.toArray(values);
        return values;
    }

    public void toArray(final double[] values) {
        int size = (int)this.size();
        if (values.length < 2 * size) {
            throw new IllegalArgumentException("values too small");
        }
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            nthreads = Math.min(nthreads, size);
            Future[] futures = new Future[nthreads];
            int k = size / nthreads;
            for (int j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Runnable(){

                    @Override
                    public void run() {
                        for (int i = firstIdx; i < lastIdx; ++i) {
                            double[] tmp = DComplexMatrix1D.this.getQuick(i);
                            values[2 * i] = tmp[0];
                            values[2 * i + 1] = tmp[1];
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futures);
        } else {
            for (int i = 0; i < size; ++i) {
                double[] tmp = this.getQuick(i);
                values[2 * i] = tmp[0];
                values[2 * i + 1] = tmp[1];
            }
        }
    }

    public String toString() {
        return this.toString("%.4f");
    }

    public String toString(String format) {
        StringBuffer s = new StringBuffer(String.format("ComplexMatrix1D: %d elements\n\n", this.size()));
        double[] elem = new double[2];
        int i = 0;
        while ((long)i < this.size()) {
            elem = this.getQuick(i);
            if (elem[1] == 0.0) {
                s.append(String.format(format + "\n", elem[0]));
            } else if (elem[0] == 0.0) {
                s.append(String.format(format + "i\n", elem[1]));
            } else if (elem[1] < 0.0) {
                s.append(String.format(format + " - " + format + "i\n", elem[0], -elem[1]));
            } else {
                s.append(String.format(format + " + " + format + "i\n", elem[0], elem[1]));
            }
            ++i;
        }
        return s.toString();
    }

    public DComplexMatrix1D viewFlip() {
        return (DComplexMatrix1D)this.view().vFlip();
    }

    public DComplexMatrix1D viewPart(int index, int width) {
        return (DComplexMatrix1D)this.view().vPart(index, width);
    }

    public DComplexMatrix1D viewSelection(DComplexProcedure condition) {
        int size = (int)this.size();
        IntArrayList matches = new IntArrayList();
        for (int i = 0; i < size; ++i) {
            if (!condition.apply(this.getQuick(i))) continue;
            matches.add(i);
        }
        matches.trimToSize();
        return this.viewSelection(matches.elements());
    }

    public DComplexMatrix1D viewSelection(int[] indexes) {
        int size = (int)this.size();
        if (indexes == null) {
            indexes = new int[size];
            int i = size - 1;
            while (--i >= 0) {
                indexes[i] = i;
            }
        }
        this.checkIndexes(indexes);
        int[] offsets = new int[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            offsets[i] = (int)this.index(indexes[i]);
        }
        return this.viewSelectionLike(offsets);
    }

    public DComplexMatrix1D viewStrides(int stride) {
        return (DComplexMatrix1D)this.view().vStrides(stride);
    }

    public double[] zDotProduct(DComplexMatrix1D y) {
        int size = (int)this.size();
        return this.zDotProduct(y, 0, size);
    }

    public double[] zDotProduct(final DComplexMatrix1D y, final int from, int length) {
        int size = (int)this.size();
        if (from < 0 || length <= 0) {
            return new double[]{0.0, 0.0};
        }
        int tail = from + length;
        if (size < tail) {
            tail = size;
        }
        if (y.size < tail) {
            tail = y.size;
        }
        length = tail - from;
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        double[] sum = new double[2];
        if (nthreads > 1 && size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int j;
            nthreads = Math.min(nthreads, length);
            Future[] futures = new Future[nthreads];
            double[][] results = new double[nthreads][2];
            int k = length / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? length : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double[] sum = new double[2];
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            int idx = k + from;
                            double[] tmp = y.getQuick(idx);
                            tmp[1] = -tmp[1];
                            sum = DComplex.plus(sum, DComplex.mult(tmp, DComplexMatrix1D.this.getQuick(idx)));
                        }
                        return sum;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (double[])futures[j].get();
                }
                sum = results[0];
                for (j = 1; j < nthreads; ++j) {
                    sum = DComplex.plus(sum, results[j]);
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int k = 0; k < length; ++k) {
                int idx = k + from;
                double[] tmp = y.getQuick(idx);
                tmp[1] = -tmp[1];
                sum = DComplex.plus(sum, DComplex.mult(tmp, this.getQuick(idx)));
            }
        }
        return sum;
    }

    public double[] zDotProduct(DComplexMatrix1D y, int from, int length, IntArrayList nonZeroIndexes) {
        int i;
        int index;
        int size = (int)this.size();
        if (from < 0 || length <= 0) {
            return new double[]{0.0, 0.0};
        }
        int tail = from + length;
        if (size < tail) {
            tail = size;
        }
        if (y.size < tail) {
            tail = y.size;
        }
        if ((length = tail - from) <= 0) {
            return new double[]{0.0, 0.0};
        }
        IntArrayList indexesCopy = nonZeroIndexes.copy();
        indexesCopy.trimToSize();
        indexesCopy.quickSort();
        int[] nonZeroIndexElements = indexesCopy.elements();
        int s = indexesCopy.size();
        for (index = 0; index < s && nonZeroIndexElements[index] < from; ++index) {
        }
        double[] sum = new double[2];
        while (--length >= 0 && index < s && (i = nonZeroIndexElements[index]) < tail) {
            double[] tmp = y.getQuick(i);
            tmp[1] = -tmp[1];
            sum = DComplex.plus(sum, DComplex.mult(tmp, this.getQuick(i)));
            ++index;
        }
        return sum;
    }

    public double[] zSum() {
        double[] sum = new double[2];
        int nthreads = ConcurrencyUtils.getNumberOfThreads();
        if (nthreads > 1 && this.size >= ConcurrencyUtils.getThreadsBeginN_1D()) {
            int j;
            nthreads = Math.min(nthreads, this.size);
            Future[] futures = new Future[nthreads];
            double[][] results = new double[nthreads][2];
            int k = this.size / nthreads;
            for (j = 0; j < nthreads; ++j) {
                final int firstIdx = j * k;
                final int lastIdx = j == nthreads - 1 ? this.size : firstIdx + k;
                futures[j] = ConcurrencyUtils.submit(new Callable<double[]>(){

                    @Override
                    public double[] call() throws Exception {
                        double[] sum = new double[2];
                        for (int k = firstIdx; k < lastIdx; ++k) {
                            sum = DComplex.plus(sum, DComplexMatrix1D.this.getQuick(k));
                        }
                        return sum;
                    }
                });
            }
            try {
                for (j = 0; j < nthreads; ++j) {
                    results[j] = (double[])futures[j].get();
                }
                sum = results[0];
                for (j = 1; j < nthreads; ++j) {
                    sum[0] = sum[0] + results[j][0];
                    sum[1] = sum[1] + results[j][1];
                }
            }
            catch (ExecutionException ex) {
                ex.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            for (int k = 0; k < this.size; ++k) {
                sum = DComplex.plus(sum, this.getQuick(k));
            }
        }
        return sum;
    }

    protected int cardinality(int maxCardinality) {
        int size = (int)this.size();
        int cardinality = 0;
        int i = 0;
        double[] tmp = new double[2];
        while (i++ < size && cardinality < maxCardinality) {
            tmp = this.getQuick(i);
            if (tmp[0] == 0.0 && tmp[1] == 0.0) continue;
            ++cardinality;
        }
        return cardinality;
    }

    protected DComplexMatrix1D getContent() {
        return this;
    }

    protected boolean haveSharedCells(DComplexMatrix1D other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        return this.getContent().haveSharedCellsRaw(other.getContent());
    }

    protected boolean haveSharedCellsRaw(DComplexMatrix1D other) {
        return false;
    }

    protected DComplexMatrix1D view() {
        return (DComplexMatrix1D)this.clone();
    }

    protected abstract DComplexMatrix1D viewSelectionLike(int[] var1);

    protected double[] zDotProduct(DComplexMatrix1D y, IntArrayList nonZeroIndexes) {
        return this.zDotProduct(y, 0, (int)this.size(), nonZeroIndexes);
    }
}

