/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map.tlong;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.tint.IntComparator;
import cern.colt.function.tint.IntProcedure;
import cern.colt.function.tlong.IntLongProcedure;
import cern.colt.function.tlong.LongFunction;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.map.AbstractMap;

public abstract class AbstractIntLongMap
extends AbstractMap {
    private static final long serialVersionUID = 1L;

    protected AbstractIntLongMap() {
    }

    public void assign(final LongFunction function) {
        this.copy().forEachPair(new IntLongProcedure(){

            @Override
            public boolean apply(int key, long value) {
                AbstractIntLongMap.this.put(key, function.apply(value));
                return true;
            }
        });
    }

    public void assign(AbstractIntLongMap other) {
        this.clear();
        other.forEachPair(new IntLongProcedure(){

            @Override
            public boolean apply(int key, long value) {
                AbstractIntLongMap.this.put(key, value);
                return true;
            }
        });
    }

    public boolean containsKey(final int key) {
        return !this.forEachKey(new IntProcedure(){

            @Override
            public boolean apply(int iterKey) {
                return key != iterKey;
            }
        });
    }

    public boolean containsValue(final long value) {
        return !this.forEachPair(new IntLongProcedure(){

            @Override
            public boolean apply(int iterKey, long iterValue) {
                return value != iterValue;
            }
        });
    }

    public AbstractIntLongMap copy() {
        return (AbstractIntLongMap)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractIntLongMap)) {
            return false;
        }
        final AbstractIntLongMap other = (AbstractIntLongMap)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new IntLongProcedure(){

            @Override
            public boolean apply(int key, long value) {
                return other.containsKey(key) && other.get(key) == value;
            }
        }) && other.forEachPair(new IntLongProcedure(){

            @Override
            public boolean apply(int key, long value) {
                return AbstractIntLongMap.this.containsKey(key) && AbstractIntLongMap.this.get(key) == value;
            }
        });
    }

    public abstract boolean forEachKey(IntProcedure var1);

    public boolean forEachPair(final IntLongProcedure procedure) {
        return this.forEachKey(new IntProcedure(){

            @Override
            public boolean apply(int key) {
                return procedure.apply(key, AbstractIntLongMap.this.get(key));
            }
        });
    }

    public abstract long get(int var1);

    public int keyOf(final long value) {
        final int[] foundKey = new int[1];
        boolean notFound = this.forEachPair(new IntLongProcedure(){

            @Override
            public boolean apply(int iterKey, long iterValue) {
                boolean found;
                boolean bl = found = value == iterValue;
                if (found) {
                    foundKey[0] = iterKey;
                }
                return !found;
            }
        });
        if (notFound) {
            return Integer.MIN_VALUE;
        }
        return foundKey[0];
    }

    public IntArrayList keys() {
        IntArrayList list = new IntArrayList(this.size());
        this.keys(list);
        return list;
    }

    public void keys(final IntArrayList list) {
        list.clear();
        this.forEachKey(new IntProcedure(){

            @Override
            public boolean apply(int key) {
                list.add(key);
                return true;
            }
        });
    }

    public void keysSortedByValue(IntArrayList keyList) {
        this.pairsSortedByValue(keyList, new LongArrayList(this.size()));
    }

    public void pairsMatching(final IntLongProcedure condition, final IntArrayList keyList, final LongArrayList valueList) {
        keyList.clear();
        valueList.clear();
        this.forEachPair(new IntLongProcedure(){

            @Override
            public boolean apply(int key, long value) {
                if (condition.apply(key, value)) {
                    keyList.add(key);
                    valueList.add(value);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(IntArrayList keyList, LongArrayList valueList) {
        this.keys(keyList);
        keyList.sort();
        valueList.setSize(keyList.size());
        int i = keyList.size();
        while (--i >= 0) {
            valueList.setQuick(i, this.get(keyList.getQuick(i)));
        }
    }

    public void pairsSortedByValue(IntArrayList keyList, LongArrayList valueList) {
        this.keys(keyList);
        this.values(valueList);
        final int[] k = keyList.elements();
        final long[] v = valueList.elements();
        Swapper swapper = new Swapper(){

            @Override
            public void swap(int a, int b) {
                long t1 = v[a];
                v[a] = v[b];
                v[b] = t1;
                int t2 = k[a];
                k[a] = k[b];
                k[b] = t2;
            }
        };
        IntComparator comp = new IntComparator(){

            @Override
            public int compare(int a, int b) {
                return v[a] < v[b] ? -1 : (v[a] > v[b] ? 1 : (k[a] < k[b] ? -1 : (k[a] == k[b] ? 0 : 1)));
            }
        };
        GenericSorting.quickSort(0, keyList.size(), comp, swapper);
    }

    public abstract boolean put(int var1, long var2);

    public abstract boolean removeKey(int var1);

    public String toString() {
        IntArrayList theKeys = this.keys();
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            int key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public String toStringByValue() {
        IntArrayList theKeys = new IntArrayList();
        this.keysSortedByValue(theKeys);
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        int maxIndex = theKeys.size() - 1;
        for (int i = 0; i <= maxIndex; ++i) {
            int key = theKeys.get(i);
            buf.append(String.valueOf(key));
            buf.append("->");
            buf.append(String.valueOf(this.get(key)));
            if (i >= maxIndex) continue;
            buf.append(", ");
        }
        buf.append("]");
        return buf.toString();
    }

    public LongArrayList values() {
        LongArrayList list = new LongArrayList(this.size());
        this.values(list);
        return list;
    }

    public void values(final LongArrayList list) {
        list.clear();
        this.forEachKey(new IntProcedure(){

            @Override
            public boolean apply(int key) {
                list.add(AbstractIntLongMap.this.get(key));
                return true;
            }
        });
    }
}

