/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tlong;

import cern.colt.PersistentObject;
import cern.colt.buffer.tlong.LongBufferConsumer;
import cern.colt.list.tlong.LongArrayList;

public class LongBuffer
extends PersistentObject
implements LongBufferConsumer {
    private static final long serialVersionUID = 1L;
    protected LongBufferConsumer target;
    protected long[] elements;
    protected LongArrayList list;
    protected int capacity;
    protected int size;

    public LongBuffer(LongBufferConsumer target, int capacity) {
        this.target = target;
        this.capacity = capacity;
        this.elements = new long[capacity];
        this.list = new LongArrayList(this.elements);
        this.size = 0;
    }

    public void add(long element) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.elements[this.size++] = element;
    }

    @Override
    public void addAllOf(LongArrayList list) {
        int listSize = list.size();
        if (this.size + listSize >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(list);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.list.setSize(this.size);
            this.target.addAllOf(this.list);
            this.size = 0;
        }
    }
}

