/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tfloat;

import cern.colt.PersistentObject;
import cern.colt.buffer.tfloat.FloatBuffer2DConsumer;
import cern.colt.list.tfloat.FloatArrayList;

public class FloatBuffer2D
extends PersistentObject
implements FloatBuffer2DConsumer {
    private static final long serialVersionUID = 1L;
    protected FloatBuffer2DConsumer target;
    protected float[] xElements;
    protected float[] yElements;
    protected FloatArrayList xList;
    protected FloatArrayList yList;
    protected int capacity;
    protected int size;

    public FloatBuffer2D(FloatBuffer2DConsumer target, int capacity) {
        this.target = target;
        this.capacity = capacity;
        this.xElements = new float[capacity];
        this.yElements = new float[capacity];
        this.xList = new FloatArrayList(this.xElements);
        this.yList = new FloatArrayList(this.yElements);
        this.size = 0;
    }

    public void add(float x, float y) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.xElements[this.size] = x;
        this.yElements[this.size++] = y;
    }

    @Override
    public void addAllOf(FloatArrayList x, FloatArrayList y) {
        int listSize = x.size();
        if (this.size + listSize >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(x, y);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.xList.setSize(this.size);
            this.yList.setSize(this.size);
            this.target.addAllOf(this.xList, this.yList);
            this.size = 0;
        }
    }
}

