/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.buffer.tfloat;

import cern.colt.PersistentObject;
import cern.colt.buffer.tfloat.FloatBufferConsumer;
import cern.colt.list.tfloat.FloatArrayList;

public class FloatBuffer
extends PersistentObject
implements FloatBufferConsumer {
    private static final long serialVersionUID = 1L;
    protected FloatBufferConsumer target;
    protected float[] elements;
    protected FloatArrayList list;
    protected int capacity;
    protected int size;

    public FloatBuffer(FloatBufferConsumer target, int capacity) {
        this.target = target;
        this.capacity = capacity;
        this.elements = new float[capacity];
        this.list = new FloatArrayList(this.elements);
        this.size = 0;
    }

    public void add(float element) {
        if (this.size == this.capacity) {
            this.flush();
        }
        this.elements[this.size++] = element;
    }

    @Override
    public void addAllOf(FloatArrayList list) {
        int listSize = list.size();
        if (this.size + listSize >= this.capacity) {
            this.flush();
        }
        this.target.addAllOf(list);
    }

    public void clear() {
        this.size = 0;
    }

    public void flush() {
        if (this.size > 0) {
            this.list.setSize(this.size);
            this.target.addAllOf(this.list);
            this.size = 0;
        }
    }
}

