/*
 * Decompiled with CFR 0.152.
 */
package georegression.transform.se;

import georegression.metric.UtilAngle;
import georegression.struct.se.Se2_F32;

public class InterpolateLinearSe2_F32 {
    public static void interpolate(Se2_F32 a, Se2_F32 b, float where, Se2_F32 output) {
        float ccw;
        float yaw1;
        float w0 = 1.0f - where;
        output.T.x = a.T.x * w0 + b.T.x * where;
        output.T.y = a.T.y * w0 + b.T.y * where;
        float yaw0 = a.getYaw();
        float cw = UtilAngle.distanceCW(yaw0, yaw1 = b.getYaw());
        float yaw = cw > (ccw = UtilAngle.distanceCCW(yaw0, yaw1)) ? yaw0 + ccw * where : yaw0 - cw * where;
        output.setYaw(yaw);
    }
}

