/*
 * Decompiled with CFR 0.152.
 */
package georegression.transform.se;

import georegression.struct.so.Quaternion_F32;
import java.util.List;
import org.ejml.data.DenseMatrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.EigenDecomposition;

public class AverageQuaternion_F32 {
    DenseMatrix64F M = new DenseMatrix64F(4, 4);
    EigenDecomposition<DenseMatrix64F> eig = DecompositionFactory.eig(4, true, true);

    public boolean process(List<Quaternion_F32> list, Quaternion_F32 average) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Input list is empty");
        }
        if (average == null) {
            throw new IllegalArgumentException("average is null");
        }
        this.M.zero();
        for (int i = 0; i < list.size(); ++i) {
            Quaternion_F32 q = list.get(i);
            this.M.data[0] = this.M.data[0] + (double)(q.w * q.w);
            this.M.data[1] = this.M.data[1] + (double)(q.w * q.x);
            this.M.data[2] = this.M.data[2] + (double)(q.w * q.y);
            this.M.data[3] = this.M.data[3] + (double)(q.w * q.z);
            this.M.data[4] = this.M.data[4] + (double)(q.x * q.w);
            this.M.data[5] = this.M.data[5] + (double)(q.x * q.x);
            this.M.data[6] = this.M.data[6] + (double)(q.x * q.y);
            this.M.data[7] = this.M.data[7] + (double)(q.x * q.z);
            this.M.data[8] = this.M.data[8] + (double)(q.y * q.w);
            this.M.data[9] = this.M.data[9] + (double)(q.y * q.x);
            this.M.data[10] = this.M.data[10] + (double)(q.y * q.y);
            this.M.data[11] = this.M.data[11] + (double)(q.y * q.z);
            this.M.data[12] = this.M.data[12] + (double)(q.z * q.w);
            this.M.data[13] = this.M.data[13] + (double)(q.z * q.x);
            this.M.data[14] = this.M.data[14] + (double)(q.z * q.y);
            this.M.data[15] = this.M.data[15] + (double)(q.z * q.z);
        }
        if (!this.eig.decompose(this.M)) {
            return false;
        }
        int largest = 0;
        double largestMag = this.eig.getEigenvalue(0).getMagnitude2();
        for (int i = 1; i < 4; ++i) {
            double mag = this.eig.getEigenvalue(i).getMagnitude2();
            if (!(mag > largestMag)) continue;
            largestMag = mag;
            largest = i;
        }
        DenseMatrix64F v = this.eig.getEigenVector(largest);
        average.w = (float)v.get(0);
        average.x = (float)v.get(1);
        average.y = (float)v.get(2);
        average.z = (float)v.get(3);
        return true;
    }
}

