/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.line;

import java.io.Serializable;

public class LineGeneral2D_F64
implements Serializable {
    public double A;
    public double B;
    public double C;

    public LineGeneral2D_F64(double a, double b, double c) {
        this.set(a, b, c);
    }

    public LineGeneral2D_F64(LineGeneral2D_F64 line) {
        this.set(line);
    }

    public LineGeneral2D_F64() {
    }

    public double getA() {
        return this.A;
    }

    public double getB() {
        return this.B;
    }

    public double getC() {
        return this.C;
    }

    public void set(LineGeneral2D_F64 original) {
        this.A = original.A;
        this.B = original.B;
        this.C = original.C;
    }

    public void set(double a, double b, double c) {
        this.A = a;
        this.B = b;
        this.C = c;
    }

    public void setA(double a) {
        this.A = a;
    }

    public void setB(double b) {
        this.B = b;
    }

    public void setC(double c) {
        this.C = c;
    }

    public void normalize() {
        double d = Math.sqrt(this.A * this.A + this.B * this.B);
        this.A /= d;
        this.B /= d;
        this.C /= d;
    }

    public double evaluate(double x, double y) {
        return this.A * x + this.B * y + this.C;
    }

    public LineGeneral2D_F64 copy() {
        return new LineGeneral2D_F64(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{ A=" + this.A + " B=" + this.B + " C=" + this.C + " }";
    }
}

