/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.sphere;

import georegression.fitting.sphere.CodecSphere3D_F64;
import georegression.struct.GeoTuple_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.shapes.Sphere3D_F64;
import java.util.List;
import org.ddogleg.optimization.functions.FunctionNtoMxN;

public class SphereToPointSignedDistanceJacobian_F64
implements FunctionNtoMxN {
    private Sphere3D_F64 sphere = new Sphere3D_F64();
    private List<Point3D_F64> points;
    private CodecSphere3D_F64 codec = new CodecSphere3D_F64();

    public void setPoints(List<Point3D_F64> points) {
        this.points = points;
    }

    @Override
    public int getNumOfInputsN() {
        return 4;
    }

    @Override
    public int getNumOfOutputsM() {
        return this.points.size();
    }

    @Override
    public void process(double[] input, double[] output) {
        this.codec.decode(input, this.sphere);
        int index = 0;
        for (int i = 0; i < this.points.size(); ++i) {
            Point3D_F64 p = this.points.get(i);
            double euclidean = this.sphere.center.distance((GeoTuple_F64)p);
            output[index++] = (this.sphere.center.x - p.x) / euclidean;
            output[index++] = (this.sphere.center.y - p.y) / euclidean;
            output[index++] = (this.sphere.center.z - p.z) / euclidean;
            output[index++] = -1.0;
        }
    }
}

