/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.cylinder;

import georegression.fitting.cylinder.CodecCylinder3D_F64;
import georegression.metric.MiscOps;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.shapes.Cylinder3D_F64;
import java.util.List;
import org.ddogleg.optimization.functions.FunctionNtoM;

public class CylinderToPointSignedDistance_F64
implements FunctionNtoM {
    private Cylinder3D_F64 cylinder = new Cylinder3D_F64();
    private List<Point3D_F64> points;
    private CodecCylinder3D_F64 codec = new CodecCylinder3D_F64();

    public void setPoints(List<Point3D_F64> points) {
        this.points = points;
    }

    @Override
    public int getNumOfInputsN() {
        return 7;
    }

    @Override
    public int getNumOfOutputsM() {
        return this.points.size();
    }

    @Override
    public void process(double[] input, double[] output) {
        this.codec.decode(input, this.cylinder);
        Point3D_F64 cp = this.cylinder.line.p;
        Vector3D_F64 cs = this.cylinder.line.slope;
        double slopeDot = cs.dot(cs);
        double slopeNorm = Math.sqrt(slopeDot);
        for (int i = 0; i < this.points.size(); ++i) {
            Point3D_F64 p = this.points.get(i);
            double x = cp.x - p.x;
            double y = cp.y - p.y;
            double z = cp.z - p.z;
            double cc = x * x + y * y + z * z;
            double b = MiscOps.dot(x, y, z, cs) / slopeNorm;
            double distance = cc - b * b;
            distance = distance < 0.0 ? 0.0 : Math.sqrt(distance);
            output[i] = distance - this.cylinder.radius;
        }
    }
}

