/*
 * Decompiled with CFR 0.152.
 */
package georegression.examples;

import georegression.fitting.se.MotionSe3PointSVD_F64;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.EulerType;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.ArrayList;
import java.util.Random;

public class ExampleTransformFitting {
    public static void main(String[] args) {
        Random rand = new Random(234L);
        Se3_F64 actual = new Se3_F64();
        ConvertRotation3D_F64.eulerToMatrix(EulerType.XYZ, 0.5, -2.0, 0.15, actual.R);
        actual.T.set(2.0, 3.0, -2.0);
        ArrayList<Point3D_F64> fromPts = new ArrayList<Point3D_F64>();
        ArrayList<Point3D_F64> toPts = new ArrayList<Point3D_F64>();
        for (int i = 0; i < 50; ++i) {
            double x = rand.nextGaussian();
            double y = rand.nextGaussian();
            double z = rand.nextGaussian();
            Point3D_F64 p = new Point3D_F64(x, y, z);
            Point3D_F64 tranP = new Point3D_F64();
            SePointOps_F64.transform(actual, p, tranP);
            fromPts.add(p);
            toPts.add(tranP);
        }
        MotionSe3PointSVD_F64 estimator = new MotionSe3PointSVD_F64();
        if (!estimator.process(fromPts, toPts)) {
            throw new RuntimeException("Estimation of Se3 failed");
        }
        Se3_F64 found = (Se3_F64)estimator.getTransformSrcToDst();
        actual.print();
        System.out.println();
        found.print();
    }
}

