/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.tests;

import org.junit.Assert;
import org.junit.Test;
import org.jzy3d.maths.Coord3d;

public class TestCoord3dRotate {
    float delta = 1.0E-6f;

    @Test
    public void testCross() throws Exception {
        Coord3d x = new Coord3d(1.0f, 0.0f, 0.0f);
        Coord3d y = new Coord3d(0.0f, 1.0f, 0.0f);
        Coord3d z = new Coord3d(0.0f, 0.0f, 1.0f);
        this.assertEqualCoord(z, x.cross(y));
    }

    @Test
    public void rotateX() throws Exception {
        Coord3d input = new Coord3d(0.0f, 1.0f, 0.0f);
        Coord3d axis = new Coord3d(1.0f, 0.0f, 0.0f);
        float angle = 90.0f;
        Coord3d expected = new Coord3d(0.0f, 0.0f, 1.0f);
        this.assertEqualCoord(expected, input.rotate(angle, axis));
    }

    @Test
    public void rotateY() throws Exception {
        Coord3d input = new Coord3d(1.0f, 0.0f, 0.0f);
        Coord3d axis = new Coord3d(0.0f, 1.0f, 0.0f);
        float angle = 90.0f;
        Coord3d expected = new Coord3d(0.0f, 0.0f, -1.0f);
        this.assertEqualCoord(expected, input.rotate(angle, axis));
    }

    @Test
    public void rotateZ() throws Exception {
        Coord3d input = new Coord3d(0.0f, 1.0f, 0.0f);
        Coord3d axis = new Coord3d(0.0f, 0.0f, 1.0f);
        float angle = 90.0f;
        Coord3d expected = new Coord3d(-1.0f, 0.0f, 0.0f);
        this.assertEqualCoord(expected, input.rotate(angle, axis));
    }

    void assertEqualCoord(Coord3d expected, Coord3d actual) {
        Assert.assertEquals((double)expected.x, (double)actual.x, (double)this.delta);
        Assert.assertEquals((double)expected.y, (double)actual.y, (double)this.delta);
        Assert.assertEquals((double)expected.z, (double)actual.z, (double)this.delta);
    }
}

