/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.text.renderers.jogl;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jzy3d.plot3d.text.renderers.jogl.ITextStyle;

public class DefaultTextStyle
implements ITextStyle {
    protected Color color;

    public DefaultTextStyle(Color color) {
        this.color = color;
    }

    @Override
    public boolean intensityOnly() {
        return false;
    }

    @Override
    public Rectangle2D getBounds(CharSequence str, Font font, FontRenderContext frc) {
        return this.getBounds(str.toString(), font, frc);
    }

    @Override
    public Rectangle2D getBounds(String str, Font font, FontRenderContext frc) {
        return this.getBounds(font.createGlyphVector(frc, str), frc);
    }

    @Override
    public Rectangle2D getBounds(GlyphVector gv, FontRenderContext frc) {
        Rectangle stringBounds = gv.getPixelBounds(frc, 0.0f, 0.0f);
        return new Rectangle2D.Double(((RectangularShape)stringBounds).getX(), ((RectangularShape)stringBounds).getY(), ((RectangularShape)stringBounds).getWidth(), ((RectangularShape)stringBounds).getHeight());
    }

    @Override
    public void drawGlyphVector(Graphics2D graphics, GlyphVector str, int x, int y) {
        graphics.setColor(Color.WHITE);
        graphics.setPaint(this.color);
        graphics.drawGlyphVector(str, x, y);
    }

    @Override
    public void draw(Graphics2D graphics, String str, int x, int y) {
        graphics.setColor(Color.WHITE);
        graphics.setPaint(this.color);
        graphics.drawString(str, x, y);
    }
}

