/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.text;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.text.ITextRenderer;
import org.jzy3d.plot3d.text.align.Halign;
import org.jzy3d.plot3d.text.align.Valign;
import org.jzy3d.plot3d.transform.Transform;

public class DrawableTextWrapper
extends AbstractDrawable {
    protected String txt;
    protected Coord3d position;
    protected Halign halign;
    protected Valign valign;
    protected Color color;
    protected ITextRenderer renderer;

    public DrawableTextWrapper(ITextRenderer renderer) {
        this("", new Coord3d(), Color.BLACK, renderer);
    }

    public DrawableTextWrapper(String txt, Coord3d position, Color color, ITextRenderer renderer) {
        this.renderer = renderer;
        this.configure(txt, position, color, Halign.CENTER, Valign.CENTER);
    }

    @Override
    public void draw(GL gl, GLU glu, Camera cam) {
        this.doTransform(gl, glu, cam);
        BoundingBox3d box = this.renderer.drawText(gl, glu, cam, this.txt, this.position, this.halign, this.valign, this.color, 0);
        this.bbox = box != null ? box.scale(new Coord3d(0.0f, 0.0f, 0.0f)) : null;
    }

    @Override
    public BoundingBox3d getBounds() {
        return this.bbox;
    }

    public void configure(String txt, Coord3d position, Color color, Halign ha, Valign va) {
        this.setText(txt);
        this.setPosition(position);
        this.setColor(color);
        this.setHalign(ha);
        this.setValign(va);
    }

    public String getText() {
        return this.txt;
    }

    public void setText(String txt) {
        this.txt = txt;
    }

    public void setPosition(Coord3d position) {
        this.position = position;
    }

    public Coord3d getPosition() {
        return this.position;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Halign getHalign() {
        return this.halign;
    }

    public void setHalign(Halign halign) {
        this.halign = halign;
    }

    public Valign getValign() {
        return this.valign;
    }

    public void setValign(Valign valign) {
        this.valign = valign;
    }

    @Override
    public String toString() {
        return "(TextBitmapDrawable) \"" + this.txt + "\" at " + this.position.toString() + " halign=" + (Object)((Object)this.halign) + " valign=" + (Object)((Object)this.valign);
    }

    @Override
    public void applyGeometryTransform(Transform transform) {
        this.position.set(transform.compute(this.position));
        this.updateBounds();
    }

    @Override
    public void updateBounds() {
    }
}

