/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.view.controllers;

import com.jogamp.newt.event.MouseEvent;
import com.jogamp.newt.event.MouseListener;
import org.jzy3d.chart.controllers.mouse.NewtMouseUtilities;
import org.jzy3d.chart.controllers.thread.camera.CameraThreadController;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.plot3d.rendering.canvas.IScreenCanvas;
import org.jzy3d.plot3d.rendering.view.View;
import org.jzy3d.plot3d.rendering.view.controllers.ViewCameraController;

public class ViewMouseController
extends ViewCameraController
implements MouseListener {
    protected IScreenCanvas canvas;
    protected Coord2d prevMouse;
    protected CameraThreadController threadController;

    public ViewMouseController() {
    }

    public ViewMouseController(View view) {
        this.addTarget(view);
    }

    public void addMouseSource(IScreenCanvas canvas) {
        this.canvas = canvas;
        this.prevMouse = Coord2d.ORIGIN;
        canvas.addMouseController(this);
    }

    @Override
    public void dispose() {
        this.canvas.removeMouseController(this);
        if (this.threadController != null) {
            this.threadController.stop();
        }
    }

    public void addSlaveThreadController(CameraThreadController controller) {
        this.removeSlaveThreadController();
        this.threadController = controller;
    }

    public void removeSlaveThreadController() {
        if (this.threadController != null) {
            this.threadController.stop();
            this.threadController = null;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (NewtMouseUtilities.isDoubleClick(e) && this.threadController != null) {
            this.threadController.start();
            return;
        }
        if (this.threadController != null) {
            this.threadController.stop();
        }
        this.prevMouse.x = e.getX();
        this.prevMouse.y = e.getY();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Coord2d mouse = new Coord2d(e.getX(), e.getY());
        if (NewtMouseUtilities.isLeftDown(e)) {
            Coord2d move = mouse.sub(this.prevMouse).div(100.0f);
            this.rotate(move);
        } else if (NewtMouseUtilities.isRightDown(e)) {
            Coord2d move = mouse.sub(this.prevMouse);
            if (move.y != 0.0f) {
                this.shift(move.y / 500.0f);
            }
        }
        this.prevMouse = mouse;
    }

    @Override
    public void mouseWheelMoved(MouseEvent e) {
        if (this.threadController != null) {
            this.threadController.stop();
        }
        float factor = NewtMouseUtilities.convertWheelRotation(e, 1.0f, 10.0f);
        this.zoom(factor);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

