/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.view.annotation;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import java.util.ArrayList;
import java.util.List;
import org.jzy3d.colors.Color;
import org.jzy3d.plot3d.primitives.AbstractComposite;
import org.jzy3d.plot3d.primitives.AbstractDrawable;
import org.jzy3d.plot3d.primitives.AbstractGeometry;
import org.jzy3d.plot3d.primitives.LineStrip;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.rendering.scene.Decomposition;
import org.jzy3d.plot3d.rendering.view.Camera;

public class BarycenterAnnotation
extends AbstractComposite {
    protected AbstractGeometry annotated;
    protected Point bary;
    protected List<LineStrip> lines;

    public BarycenterAnnotation(AbstractGeometry annotated) {
        Color c = Color.BLACK;
        this.annotated = annotated;
        this.bary = new Point();
        this.bary.setWidth(5.0f);
        this.lines = new ArrayList<LineStrip>();
        for (Point pt : annotated.getPoints()) {
            Point b2 = this.bary.clone();
            Point pt2 = pt.clone();
            LineStrip line = new LineStrip(b2, pt2);
            line.setWireframeColor(c);
            this.lines.add(line);
        }
        this.add(this.bary);
        this.add(this.lines);
        this.setColor(c);
        this.setWireframeColor(c);
    }

    @Override
    public void draw(GL gl, GLU glu, Camera camera) {
        this.bary.xyz = this.annotated.getBarycentre();
        int k = 0;
        for (LineStrip line : this.lines) {
            line.get((int)0).xyz = this.bary.xyz.clone();
            line.get((int)1).xyz = this.annotated.get((int)k).xyz.clone();
            ++k;
        }
        super.draw(gl, glu, camera);
    }

    public static List<BarycenterAnnotation> annotate(AbstractComposite composite) {
        ArrayList<BarycenterAnnotation> annotations = new ArrayList<BarycenterAnnotation>();
        ArrayList<AbstractDrawable> items = Decomposition.getDecomposition(composite);
        for (AbstractDrawable item : items) {
            if (!(item instanceof AbstractGeometry)) continue;
            annotations.add(new BarycenterAnnotation((AbstractGeometry)item));
        }
        return annotations;
    }
}

