/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.view;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.util.awt.Overlay;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.jzy3d.chart.ChartView;
import org.jzy3d.chart.factories.IChartComponentFactory;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.Parallelepiped;
import org.jzy3d.plot3d.primitives.axes.AxeBox;
import org.jzy3d.plot3d.rendering.canvas.ICanvas;
import org.jzy3d.plot3d.rendering.canvas.Quality;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.scene.Scene;
import org.jzy3d.plot3d.rendering.tooltips.ITooltipRenderer;
import org.jzy3d.plot3d.rendering.view.AWTImageViewport;
import org.jzy3d.plot3d.rendering.view.Renderer2d;
import org.jzy3d.plot3d.rendering.view.ViewportConfiguration;
import org.jzy3d.plot3d.rendering.view.ViewportMode;
import org.jzy3d.plot3d.rendering.view.modes.ViewPositionMode;

public class AWTView
extends ChartView {
    protected List<ITooltipRenderer> tooltips;
    protected List<Renderer2d> renderers;
    protected Color bgOverlay = new Color(0, 0, 0, 0);
    protected AWTImageViewport bgViewport = new AWTImageViewport();
    protected BufferedImage bgImg = null;
    protected Overlay overlay;

    public AWTView(IChartComponentFactory factory, Scene scene, ICanvas canvas, Quality quality) {
        super(factory, scene, canvas, quality);
        this.renderers = new ArrayList<Renderer2d>(1);
        this.tooltips = new ArrayList<ITooltipRenderer>();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.renderers.clear();
    }

    @Override
    public void renderAxeBox(GL gl, GLU glu) {
        if (this.axeBoxDisplayed) {
            if (gl.isGL2()) {
                gl.getGL2().glMatrixMode(5888);
            } else {
                GLES2CompatUtils.glMatrixMode(5888);
            }
            this.scene.getLightSet().disable(gl);
            this.axe.setScale(this.scaling);
            this.axe.draw(gl, glu, this.cam);
            if (this.DISPLAY_AXE_WHOLE_BOUNDS) {
                AxeBox abox = (AxeBox)this.axe;
                BoundingBox3d box = abox.getWholeBounds();
                Parallelepiped p = new Parallelepiped(box);
                p.setFaceDisplayed(false);
                p.setWireframeColor(org.jzy3d.colors.Color.MAGENTA);
                p.setWireframeDisplayed(true);
                p.draw(gl, glu, this.cam);
            }
            this.scene.getLightSet().enableLightIfThereAreLights(gl);
        }
    }

    @Override
    protected void correctCameraPositionForIncludingTextLabels(GL gl, GLU glu, ViewportConfiguration viewport) {
        this.cam.setViewPort(viewport);
        this.cam.shoot(gl, glu, this.cameraMode);
        this.axe.draw(gl, glu, this.cam);
        this.clear(gl);
        AxeBox abox = (AxeBox)this.axe;
        BoundingBox3d newBounds = abox.getWholeBounds().scale(this.scaling);
        if (this.viewmode == ViewPositionMode.TOP) {
            float radius = Math.max(newBounds.getXmax() - newBounds.getXmin(), newBounds.getYmax() - newBounds.getYmin()) / 2.0f;
            radius += radius * STRETCH_RATIO;
            this.cam.setRenderingSphereRadius(radius);
        } else {
            this.cam.setRenderingSphereRadius((float)newBounds.getRadius());
        }
        Coord3d target = newBounds.getCenter();
        Coord3d eye = this.viewpoint.cartesian().add(target);
        this.cam.setTarget(target);
        this.cam.setEye(eye);
    }

    @Override
    public void renderOverlay(GL gl, ViewportConfiguration viewport) {
        if (!this.hasOverlayStuffs()) {
            return;
        }
        if (this.overlay == null) {
            this.overlay = new Overlay(this.canvas.getDrawable());
        }
        if (gl.isGL2()) {
            gl.getGL2().glPolygonMode(1032, 6914);
        }
        gl.glViewport(viewport.x, viewport.y, viewport.width, viewport.height);
        if (this.overlay != null && viewport.width > 0 && viewport.height > 0) {
            Graphics2D g2d = null;
            g2d = this.overlay.createGraphics();
            g2d.setBackground(this.bgOverlay);
            g2d.clearRect(0, 0, this.canvas.getRendererWidth(), this.canvas.getRendererHeight());
            for (ITooltipRenderer t : this.tooltips) {
                t.render(g2d);
            }
            for (Renderer2d renderer : this.renderers) {
                renderer.paint(g2d);
            }
            this.overlay.markDirty(0, 0, this.canvas.getRendererWidth(), this.canvas.getRendererHeight());
            this.overlay.drawAll();
            g2d.dispose();
        }
    }

    @Override
    public void renderBackground(GL gl, GLU glu, float left, float right) {
        if (this.bgImg != null) {
            this.bgViewport.setViewPort(this.canvas.getRendererWidth(), this.canvas.getRendererHeight(), left, right);
            this.bgViewport.render(gl, glu);
        }
    }

    @Override
    public void renderBackground(GL gl, GLU glu, ViewportConfiguration viewport) {
        if (this.bgImg != null) {
            this.bgViewport.setViewPort(viewport);
            this.bgViewport.render(gl, glu);
        }
    }

    public void setBackgroundImage(BufferedImage i) {
        this.bgImg = i;
        this.bgViewport.setImage(this.bgImg, this.bgImg.getWidth(), this.bgImg.getHeight());
        this.bgViewport.setViewportMode(ViewportMode.STRETCH_TO_FILL);
    }

    public BufferedImage getBackgroundImage() {
        return this.bgImg;
    }

    public void clearTooltips() {
        this.tooltips.clear();
    }

    public void setTooltip(ITooltipRenderer tooltip) {
        this.tooltips.clear();
        this.tooltips.add(tooltip);
    }

    public void addTooltip(ITooltipRenderer tooltip) {
        this.tooltips.add(tooltip);
    }

    public void setTooltips(List<ITooltipRenderer> tooltip) {
        this.tooltips.clear();
        this.tooltips.addAll(tooltip);
    }

    public void addTooltips(List<ITooltipRenderer> tooltip) {
        this.tooltips.addAll(tooltip);
    }

    public List<ITooltipRenderer> getTooltips() {
        return this.tooltips;
    }

    public void addRenderer2d(Renderer2d renderer) {
        this.renderers.add(renderer);
    }

    public void removeRenderer2d(Renderer2d renderer) {
        this.renderers.remove(renderer);
    }

    protected boolean hasOverlayStuffs() {
        return this.tooltips.size() > 0 || this.renderers.size() > 0;
    }
}

