/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.rendering.textures;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.util.texture.Texture;
import com.jogamp.opengl.util.texture.TextureCoords;
import com.jogamp.opengl.util.texture.TextureIO;
import java.io.File;
import java.io.IOException;
import org.jzy3d.plot3d.primitives.IGLBindedResource;

public class SharedTexture
implements IGLBindedResource {
    protected Texture texture = null;
    protected String file;
    protected TextureCoords coords;
    protected float halfWidth;
    protected float halfHeight;

    protected SharedTexture() {
    }

    public SharedTexture(String file) {
        this.file = file;
    }

    public Texture getTexture(GL gl) {
        if (this.texture == null) {
            this.mount(gl);
        }
        return this.texture;
    }

    @Override
    public void mount(GL gl) {
        try {
            this.load(gl, this.file);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.coords = this.texture.getImageTexCoords();
        this.halfWidth = this.texture.getWidth() / 2;
        this.halfHeight = this.texture.getHeight() / 2;
    }

    @Override
    public boolean hasMountedOnce() {
        return this.texture != null;
    }

    protected void load(GL gl, String fileName) throws GLException, IOException {
        this.texture = TextureIO.newTexture(new File(fileName), false);
        this.texture.setTexParameteri(gl, 10240, 9728);
        this.texture.setTexParameteri(gl, 10241, 9728);
    }

    public String getFile() {
        return this.file;
    }

    public TextureCoords getCoords() {
        return this.coords;
    }

    public float getHalfWidth() {
        return this.halfWidth;
    }

    public float getHalfHeight() {
        return this.halfHeight;
    }
}

