/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.selectable;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import java.util.List;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ISingleColorable;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Polygon2d;
import org.jzy3d.plot3d.primitives.Scatter;
import org.jzy3d.plot3d.primitives.selectable.Selectable;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.Camera;

public class SelectableScatter
extends Scatter
implements ISingleColorable,
Selectable {
    protected boolean[] isHighlighted;
    protected Color highlightColor = Color.RED.clone();
    protected Coord3d[] projection;

    public SelectableScatter(Coord3d[] coordinates, Color[] colors) {
        super(coordinates, colors);
    }

    @Override
    public void draw(GL gl, GLU glu, Camera cam) {
        this.doTransform(gl, glu, cam);
        if (gl.isGL2()) {
            gl.getGL2().glPointSize(this.width);
            gl.getGL2().glBegin(0);
            if (this.colors == null) {
                gl.getGL2().glColor4f(this.rgb.r, this.rgb.g, this.rgb.b, this.rgb.a);
            }
            if (this.coordinates != null) {
                int k = 0;
                for (Coord3d c : this.coordinates) {
                    if (this.colors != null) {
                        if (this.isHighlighted[k]) {
                            gl.getGL2().glColor4f(this.highlightColor.r, this.highlightColor.g, this.highlightColor.b, this.highlightColor.a);
                        } else {
                            gl.getGL2().glColor4f(this.colors[k].r, this.colors[k].g, this.colors[k].b, this.colors[k].a);
                        }
                        ++k;
                    }
                    gl.getGL2().glVertex3f(c.x, c.y, c.z);
                }
            }
            gl.getGL2().glEnd();
        } else {
            GLES2CompatUtils.glPointSize(this.width);
            gl.getGL2().glBegin(0);
            if (this.colors == null) {
                GLES2CompatUtils.glColor4f(this.rgb.r, this.rgb.g, this.rgb.b, this.rgb.a);
            }
            if (this.coordinates != null) {
                int k = 0;
                for (Coord3d c : this.coordinates) {
                    if (this.colors != null) {
                        if (this.isHighlighted[k]) {
                            GLES2CompatUtils.glColor4f(this.highlightColor.r, this.highlightColor.g, this.highlightColor.b, this.highlightColor.a);
                        } else {
                            GLES2CompatUtils.glColor4f(this.colors[k].r, this.colors[k].g, this.colors[k].b, this.colors[k].a);
                        }
                        ++k;
                    }
                    GLES2CompatUtils.glVertex3f(c.x, c.y, c.z);
                }
            }
            GLES2CompatUtils.glEnd();
        }
    }

    @Override
    public void project(GL gl, GLU glu, Camera cam) {
        this.projection = cam.modelToScreen(gl, glu, this.getData());
    }

    public Coord3d[] getProjection() {
        return this.projection;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
    }

    public void setHighlighted(int id, boolean value) {
        this.isHighlighted[id] = value;
    }

    public boolean getHighlighted(int id) {
        return this.isHighlighted[id];
    }

    public void resetHighlighting() {
        this.isHighlighted = new boolean[this.coordinates.length];
    }

    @Override
    public void setData(Coord3d[] coordinates) {
        this.coordinates = coordinates;
        this.isHighlighted = new boolean[coordinates.length];
        this.bbox.reset();
        for (Coord3d c : coordinates) {
            this.bbox.add(c);
        }
    }

    @Override
    public Coord3d[] getData() {
        return this.coordinates;
    }

    @Override
    public Polygon2d getHull2d() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public List<Coord3d> getLastProjection() {
        throw new RuntimeException("not implemented");
    }
}

