/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.log;

import com.jogamp.opengl.GL;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.Scatter;
import org.jzy3d.plot3d.primitives.log.GlVertexExecutor;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.transform.space.SpaceTransformer;

public class AxeTransformableScatter
extends Scatter {
    SpaceTransformer transformers;

    public AxeTransformableScatter(SpaceTransformer transformers) {
        this.bbox = new BoundingBox3d();
        this.transformers = transformers;
        this.setWidth(1.0f);
        this.setColor(Color.BLACK);
    }

    public AxeTransformableScatter(Coord3d[] coordinates, SpaceTransformer transformers) {
        this(coordinates, Color.BLACK, transformers);
    }

    public AxeTransformableScatter(Coord3d[] coordinates, Color rgb, SpaceTransformer transformers) {
        this(coordinates, rgb, 1.0f, transformers);
    }

    public AxeTransformableScatter(Coord3d[] coordinates, Color rgb, float width, SpaceTransformer transformers) {
        this.bbox = new BoundingBox3d();
        this.transformers = transformers;
        this.setData(coordinates);
        this.setWidth(width);
        this.setColor(rgb);
    }

    public AxeTransformableScatter(Coord3d[] coordinates, Color[] colors, SpaceTransformer transformers) {
        this(coordinates, colors, 1.0f, transformers);
    }

    public AxeTransformableScatter(Coord3d[] coordinates, Color[] colors, float width, SpaceTransformer transformers) {
        this.bbox = new BoundingBox3d();
        this.transformers = transformers;
        this.setData(coordinates);
        this.setWidth(width);
        this.setColors(colors);
    }

    @Override
    public void drawGLES2() {
        GLES2CompatUtils.glPointSize(this.width);
        GLES2CompatUtils.glBegin(0);
        if (this.colors == null) {
            GLES2CompatUtils.glColor4f(this.rgb.r, this.rgb.g, this.rgb.b, this.rgb.a);
        }
        if (this.coordinates != null) {
            int k = 0;
            for (Coord3d c : this.coordinates) {
                if (this.colors != null) {
                    GLES2CompatUtils.glColor4f(this.colors[k].r, this.colors[k].g, this.colors[k].b, this.colors[k].a);
                    ++k;
                }
                GLES2CompatUtils.glVertex3f(this.transformers.getX().compute(c.x), this.transformers.getY().compute(c.y), this.transformers.getZ().compute(c.z));
            }
        }
        GLES2CompatUtils.glEnd();
    }

    @Override
    public void drawGL2(GL gl) {
        gl.getGL2().glPointSize(this.width);
        gl.getGL2().glBegin(0);
        if (this.colors == null) {
            gl.getGL2().glColor4f(this.rgb.r, this.rgb.g, this.rgb.b, this.rgb.a);
        }
        if (this.coordinates != null) {
            int k = 0;
            for (Coord3d c : this.coordinates) {
                if (this.colors != null) {
                    gl.getGL2().glColor4f(this.colors[k].r, this.colors[k].g, this.colors[k].b, this.colors[k].a);
                    ++k;
                }
                GlVertexExecutor.Vertex(gl, new Coord3d(c.x, c.y, c.z), this.transformers);
            }
        }
        gl.getGL2().glEnd();
    }

    @Override
    public void updateBounds() {
        this.bbox.reset();
        for (Coord3d c : this.coordinates) {
            this.bbox.add(this.transformers.compute(c));
        }
    }
}

