/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.log;

import com.jogamp.opengl.GL;
import java.util.List;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.ConcurrentScatterPoint;
import org.jzy3d.plot3d.primitives.LightPoint;
import org.jzy3d.plot3d.primitives.log.GlVertexExecutor;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.transform.space.SpaceTransformer;

public class AxeTransformableConcuurentScatterPoint
extends ConcurrentScatterPoint {
    SpaceTransformer transformers;

    public AxeTransformableConcuurentScatterPoint(SpaceTransformer transformers) {
        this.transformers = transformers;
    }

    public AxeTransformableConcuurentScatterPoint(List<LightPoint> points, float width, SpaceTransformer transformers) {
        super(points, width);
        this.transformers = transformers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawGLES2() {
        GLES2CompatUtils.glPointSize(this.width);
        GLES2CompatUtils.glBegin(0);
        if (this.points != null) {
            List list = this.points;
            synchronized (list) {
                for (LightPoint p : this.points) {
                    GLES2CompatUtils.glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
                    GLES2CompatUtils.glVertex3f(this.transformers.getX().compute(p.xyz.x), this.transformers.getY().compute(p.xyz.y), this.transformers.getZ().compute(p.xyz.z));
                }
            }
        }
        GLES2CompatUtils.glEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawGL2(GL gl) {
        gl.getGL2().glPointSize(this.width);
        gl.getGL2().glBegin(0);
        if (this.points != null) {
            List list = this.points;
            synchronized (list) {
                for (LightPoint p : this.points) {
                    gl.getGL2().glColor4f(p.rgb.r, p.rgb.g, p.rgb.b, p.rgb.a);
                    GlVertexExecutor.Vertex(gl, new Coord3d(p.xyz.x, p.xyz.y, p.xyz.z), this.transformers);
                }
            }
        }
        gl.getGL2().glEnd();
    }
}

