/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives.axes;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.PlaneAxis;
import org.jzy3d.maths.Range;
import org.jzy3d.plot3d.primitives.LineStrip;
import org.jzy3d.plot3d.primitives.axes.AxeBox;
import org.jzy3d.plot3d.primitives.axes.layout.IAxeLayout;
import org.jzy3d.plot3d.primitives.contour.ContourLevel;
import org.jzy3d.plot3d.primitives.contour.ContourMesh;
import org.jzy3d.plot3d.primitives.textured.DrawableTexture;
import org.jzy3d.plot3d.rendering.textures.BufferedImageTexture;
import org.jzy3d.plot3d.rendering.textures.SharedTexture;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.text.align.Halign;
import org.jzy3d.plot3d.text.align.Valign;

public class ContourAxeBox
extends AxeBox {
    protected float xmin;
    protected float xmax;
    protected float ymin;
    protected float ymax;
    protected float zmin;
    protected float zmax;
    protected BufferedImage contourImg;
    protected DrawableTexture contourTexture;
    protected ContourMesh mesh;

    public ContourAxeBox(BoundingBox3d bbox, IAxeLayout layout) {
        super(bbox, layout);
    }

    public ContourAxeBox(BoundingBox3d bbox) {
        super(bbox);
    }

    public BufferedImage getContourImage() {
        return this.contourImg;
    }

    public void setContourImg(BufferedImage contourImage, Range xrange, Range yrange) {
        this.contourImg = contourImage;
        this.rebuildTexture();
    }

    public ContourMesh getContourMesh() {
        return this.mesh;
    }

    public void setContourMesh(ContourMesh contour) {
        this.mesh = contour;
    }

    protected void rebuildTexture() {
        BufferedImageTexture contourResource = new BufferedImageTexture(this.contourImg);
        float zrange = this.zmax - this.zmin;
        this.contourTexture = new DrawableTexture((SharedTexture)contourResource, PlaneAxis.Z, this.zmin - zrange / 1000.0f, this.getDefaultTextureMapping());
    }

    protected List<Coord2d> getDefaultTextureMapping() {
        ArrayList<Coord2d> mapping = new ArrayList<Coord2d>(4);
        mapping.add(new Coord2d(this.xmin, this.ymin));
        mapping.add(new Coord2d(this.xmax, this.ymin));
        mapping.add(new Coord2d(this.xmax, this.ymax));
        mapping.add(new Coord2d(this.xmin, this.ymax));
        return mapping;
    }

    @Override
    protected void setAxeBox(float xmin, float xmax, float ymin, float ymax, float zmin, float zmax) {
        super.setAxeBox(xmin, xmax, ymin, ymax, zmin, zmax);
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
        this.zmin = zmin;
        this.zmax = zmax;
        if (this.contourImg != null) {
            this.rebuildTexture();
        }
        if (this.mesh != null) {
            for (ContourLevel line : this.mesh.lines.getContourLevels()) {
                line.fixZ(zmin);
            }
        }
    }

    @Override
    public void draw(GL gl, GLU glu, Camera camera) {
        super.draw(gl, glu, camera);
        if (this.contourTexture != null) {
            this.contourTexture.draw(gl, glu, camera);
        }
        if (this.mesh != null) {
            this.drawMesh(gl, glu, camera, this.mesh);
        }
    }

    public void drawMesh(GL gl, GLU glu, Camera camera, ContourMesh mesh) {
        for (ContourLevel line : mesh.lines.getContourLevels()) {
            line.draw(gl, glu, camera);
        }
        for (Double level : mesh.getLevels()) {
            String label = mesh.getLevelLabel(level);
            ContourLevel contour = mesh.lines.getContourLevel(level);
            if (label == null || level == null) continue;
            for (LineStrip strip : contour.getLines()) {
                Coord3d position = strip.get((int)(strip.size() / 2)).xyz;
                this.txt.drawText(gl, glu, camera, label, position, Halign.CENTER, Valign.CENTER, Color.BLACK, 0);
            }
        }
    }
}

