/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import com.jogamp.opengl.glu.GLUquadric;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ISingleColorable;
import org.jzy3d.events.DrawableChangedEvent;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.AbstractWireframeable;
import org.jzy3d.plot3d.rendering.compat.GLES2CompatUtils;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.transform.Transform;

public class Tube
extends AbstractWireframeable
implements ISingleColorable {
    private float x;
    private float y;
    private float z;
    private float radiusBottom;
    private float radiusTop;
    private float height;
    private int slices;
    private int stacks;
    private Color color;

    public Tube() {
        this.bbox = new BoundingBox3d();
        this.setPosition(Coord3d.ORIGIN);
        this.setVolume(10.0f, 10.0f, 30.0f);
        this.setSlicing(15, 15);
        this.setColor(Color.BLACK);
    }

    public Tube(Coord3d position, float radius, float height, int hslicing, int vslicing, Color color) {
        this.bbox = new BoundingBox3d();
        this.setPosition(position);
        this.setVolume(radius, radius, height);
        this.setSlicing(hslicing, vslicing);
        this.setColor(color);
    }

    @Override
    public void draw(GL gl, GLU glu, Camera cam) {
        this.doTransform(gl, glu, cam);
        if (gl.isGL2()) {
            gl.getGL2().glTranslatef(this.x, this.y, this.z);
        } else {
            GLES2CompatUtils.glTranslatef(this.x, this.y, this.z);
        }
        gl.glLineWidth(this.wfwidth);
        GLUquadric qobj = glu.gluNewQuadric();
        if (gl.isGL2()) {
            if (this.facestatus) {
                if (this.wfstatus) {
                    gl.glEnable(32823);
                    gl.glPolygonOffset(1.0f, 1.0f);
                }
                gl.getGL2().glPolygonMode(1032, 6914);
                gl.getGL2().glColor4f(this.color.r, this.color.g, this.color.b, this.color.a);
                glu.gluCylinder(qobj, this.radiusBottom, this.radiusTop, this.height, this.slices, this.stacks);
                if (this.wfstatus) {
                    gl.glDisable(32823);
                }
            }
            if (this.wfstatus) {
                gl.getGL2().glPolygonMode(1032, 6913);
                gl.getGL2().glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
                glu.gluCylinder(qobj, this.radiusBottom, this.radiusTop, this.height, this.slices, this.stacks);
            }
        } else {
            if (this.facestatus) {
                if (this.wfstatus) {
                    gl.glEnable(32823);
                    gl.glPolygonOffset(1.0f, 1.0f);
                }
                GLES2CompatUtils.glPolygonMode(1032, 6914);
                GLES2CompatUtils.glColor4f(this.color.r, this.color.g, this.color.b, this.color.a);
                glu.gluCylinder(qobj, this.radiusBottom, this.radiusTop, this.height, this.slices, this.stacks);
                if (this.wfstatus) {
                    gl.glDisable(32823);
                }
            }
            if (this.wfstatus) {
                GLES2CompatUtils.glPolygonMode(1032, 6913);
                GLES2CompatUtils.glColor4f(this.wfcolor.r, this.wfcolor.g, this.wfcolor.b, this.wfcolor.a);
                glu.gluCylinder(qobj, this.radiusBottom, this.radiusTop, this.height, this.slices, this.stacks);
            }
        }
        this.doDrawBounds(gl, glu, cam);
    }

    @Override
    public void applyGeometryTransform(Transform transform) {
        Coord3d c = transform.compute(new Coord3d(this.x, this.y, this.z));
        this.x = c.x;
        this.y = c.y;
        this.z = c.z;
        this.updateBounds();
    }

    @Override
    public void updateBounds() {
        this.bbox.reset();
        this.bbox.add(this.x + Math.max(this.radiusBottom, this.radiusTop), this.y + Math.max(this.radiusBottom, this.radiusTop), this.z);
        this.bbox.add(this.x - Math.max(this.radiusBottom, this.radiusTop), this.y - Math.max(this.radiusBottom, this.radiusTop), this.z);
        this.bbox.add(this.x + Math.max(this.radiusBottom, this.radiusTop), this.y + Math.max(this.radiusBottom, this.radiusTop), this.z + this.height);
        this.bbox.add(this.x - Math.max(this.radiusBottom, this.radiusTop), this.y - Math.max(this.radiusBottom, this.radiusTop), this.z + this.height);
    }

    public void setData(Coord3d position, float radiusBottom, float radiusTop, float height, int slices, int stacks) {
        this.setPosition(position);
        this.setVolume(radiusBottom, radiusTop, height);
        this.setSlicing(slices, stacks);
    }

    public void setPosition(Coord3d position) {
        this.x = position.x;
        this.y = position.y;
        this.z = position.z;
        this.bbox.reset();
        this.bbox.add(this.x + Math.max(this.radiusBottom, this.radiusTop), this.y + Math.max(this.radiusBottom, this.radiusTop), this.z + this.height);
        this.bbox.add(this.x - Math.max(this.radiusBottom, this.radiusTop), this.y - Math.max(this.radiusBottom, this.radiusTop), this.z - this.height);
    }

    public void setVolume(float radiusBottom, float radiusTop, float height) {
        this.radiusBottom = radiusBottom;
        this.radiusTop = radiusTop;
        this.height = height;
        this.updateBounds();
    }

    public void setSlicing(int verticalWires, int horizontalWires) {
        this.slices = verticalWires;
        this.stacks = horizontalWires;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        this.fireDrawableChanged(new DrawableChangedEvent(this, 2));
    }

    @Override
    public Color getColor() {
        return this.color;
    }
}

