/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.primitives;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.glu.GLU;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.colors.IMultiColorable;
import org.jzy3d.colors.ISingleColorable;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot3d.primitives.AbstractWireframeable;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.Polygon;
import org.jzy3d.plot3d.rendering.view.Camera;
import org.jzy3d.plot3d.transform.Transform;

public class Parallelepiped
extends AbstractWireframeable
implements ISingleColorable,
IMultiColorable {
    private ColorMapper mapper;
    private Polygon[] quads;
    private Color color;

    public Parallelepiped() {
        this.bbox = new BoundingBox3d();
    }

    public Parallelepiped(BoundingBox3d b) {
        this.bbox = new BoundingBox3d();
        this.setData(b);
    }

    @Override
    public void draw(GL gl, GLU glu, Camera cam) {
        for (Polygon quad : this.quads) {
            quad.draw(gl, glu, cam);
        }
    }

    @Override
    public void setTransform(Transform transform) {
        this.transform = transform;
        for (Polygon quad : this.quads) {
            quad.setTransform(transform);
        }
    }

    @Override
    public void setWireframeColor(Color color) {
        if (this.quads != null) {
            for (Polygon quad : this.quads) {
                quad.setWireframeColor(color);
            }
        }
    }

    @Override
    public void setWireframeDisplayed(boolean status) {
        if (this.quads != null) {
            for (Polygon quad : this.quads) {
                quad.setWireframeDisplayed(status);
            }
        }
    }

    @Override
    public void setWireframeWidth(float width) {
        if (this.quads != null) {
            for (Polygon quad : this.quads) {
                quad.setWireframeWidth(width);
            }
        }
    }

    @Override
    public void setFaceDisplayed(boolean status) {
        if (this.quads != null) {
            for (Polygon quad : this.quads) {
                quad.setFaceDisplayed(status);
            }
        }
    }

    @Override
    public Color getWireframeColor() {
        return this.quads[0].getWireframeColor();
    }

    @Override
    public boolean getWireframeDisplayed() {
        return this.quads[0].getWireframeDisplayed();
    }

    @Override
    public float getWireframeWidth() {
        return this.quads[0].getWireframeWidth();
    }

    @Override
    public boolean getFaceDisplayed() {
        return this.quads[0].getFaceDisplayed();
    }

    public void setData(BoundingBox3d box) {
        this.bbox.reset();
        this.bbox.add(box);
        this.quads = new Polygon[6];
        this.quads[0] = new Polygon();
        this.quads[0].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmin(), this.bbox.getZmax())), false);
        this.quads[0].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmin(), this.bbox.getZmin())), false);
        this.quads[0].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmax(), this.bbox.getZmin())), false);
        this.quads[0].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmax(), this.bbox.getZmax())), false);
        this.quads[0].updateBounds();
        this.quads[1] = new Polygon();
        this.quads[1].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmax(), this.bbox.getZmax())), false);
        this.quads[1].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmax(), this.bbox.getZmin())), false);
        this.quads[1].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmin())), false);
        this.quads[1].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmax())), false);
        this.quads[1].updateBounds();
        this.quads[2] = new Polygon();
        this.quads[2].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmax(), this.bbox.getZmax())), false);
        this.quads[2].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmax(), this.bbox.getZmin())), false);
        this.quads[2].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmax(), this.bbox.getZmin())), false);
        this.quads[2].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmax(), this.bbox.getZmax())), false);
        this.quads[2].updateBounds();
        this.quads[3] = new Polygon();
        this.quads[3].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmax())), false);
        this.quads[3].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmin())), false);
        this.quads[3].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmin(), this.bbox.getZmin())), false);
        this.quads[3].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmin(), this.bbox.getZmax())), false);
        this.quads[3].updateBounds();
        this.quads[4] = new Polygon();
        this.quads[4].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmax())), false);
        this.quads[4].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmin(), this.bbox.getZmax())), false);
        this.quads[4].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmax(), this.bbox.getZmax())), false);
        this.quads[4].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmax(), this.bbox.getZmax())), false);
        this.quads[4].updateBounds();
        this.quads[5] = new Polygon();
        this.quads[5].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmin(), this.bbox.getZmin())), false);
        this.quads[5].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmin(), this.bbox.getZmin())), false);
        this.quads[5].add(new Point(new Coord3d(this.bbox.getXmin(), this.bbox.getYmax(), this.bbox.getZmin())), false);
        this.quads[5].add(new Point(new Coord3d(this.bbox.getXmax(), this.bbox.getYmax(), this.bbox.getZmin())), false);
        this.quads[5].updateBounds();
    }

    @Override
    public void setColorMapper(ColorMapper mapper) {
        this.mapper = mapper;
        for (Polygon quad : this.quads) {
            quad.setColorMapper(mapper);
        }
    }

    @Override
    public ColorMapper getColorMapper() {
        return this.mapper;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        for (Polygon quad : this.quads) {
            quad.setColor(color);
        }
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void applyGeometryTransform(Transform transform) {
        for (Polygon quad : this.quads) {
            quad.applyGeometryTransform(transform);
        }
    }

    @Override
    public void updateBounds() {
        throw new RuntimeException("not implemented");
    }
}

