/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.builder.concrete;

import java.util.ArrayList;
import java.util.List;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Range;
import org.jzy3d.plot3d.builder.Grid;
import org.jzy3d.plot3d.builder.Mapper;

public class OrthonormalGrid
extends Grid {
    public OrthonormalGrid(Range xyrange, int xysteps) {
        super(xyrange, xysteps);
    }

    public OrthonormalGrid(Range xrange, int xsteps, Range yrange, int ysteps) {
        super(xrange, xsteps, yrange, ysteps);
    }

    @Override
    public List<Coord3d> apply(Mapper mapper) {
        double xstep = (double)this.xrange.getRange() / (double)(this.xsteps - 1);
        double ystep = (double)this.yrange.getRange() / (double)(this.ysteps - 1);
        ArrayList<Coord3d> output = new ArrayList<Coord3d>(this.xsteps * this.ysteps);
        for (int xi = 0; xi < this.xsteps; ++xi) {
            for (int yi = 0; yi < this.ysteps; ++yi) {
                double x = (double)this.xrange.getMin() + (double)xi * xstep;
                double y = (double)this.yrange.getMin() + (double)yi * ystep;
                output.add(new Coord3d(x, y, mapper.f(x, y)));
            }
        }
        return output;
    }
}

