/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot3d.builder.concrete;

import java.util.ArrayList;
import java.util.List;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.Coordinates;
import org.jzy3d.plot3d.builder.concrete.OrthonormalTessellator;
import org.jzy3d.plot3d.primitives.AbstractComposite;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.Polygon;
import org.jzy3d.plot3d.primitives.Shape;

@Deprecated
public class OldRingTesselator
extends OrthonormalTessellator {
    public float[] x;
    public float[] y;
    public float[][] z;

    @Override
    public AbstractComposite build(List<Coord3d> coordinates) {
        Coordinates coords = new Coordinates(coordinates);
        this.setData(coords.getX(), coords.getY(), coords.getZ());
        Shape s = new Shape();
        s.add(this.getSquarePolygonsOnCoordinates());
        return s;
    }

    public List<Polygon> getExtrapolatedRingPolygons(float ringMax, ColorMapper cmap, Color colorFactor) {
        float[] xbackup = this.x;
        float[] ybackup = this.y;
        float[][] zbackup = this.z;
        float step = this.x[1] - this.x[0];
        int nstep = this.x.length;
        int ENLARGE = 2;
        int required = (int)Math.ceil((ringMax * 2.0f - step * (float)nstep) / step);
        int n = required = required < 0 ? ENLARGE : required + ENLARGE;
        if (required > 0) {
            this.extrapolate(required);
        }
        List<Polygon> polygons = this.getInterpolatedRingPolygons(0.0f, ringMax, cmap, colorFactor);
        this.x = xbackup;
        this.y = ybackup;
        this.z = zbackup;
        return polygons;
    }

    public void extrapolate(int n) {
        float[] xnew = new float[this.x.length + n * 2];
        float[] ynew = new float[this.y.length + n * 2];
        float[][] znew = new float[this.x.length + n * 2][this.y.length + n * 2];
        float xmin = this.x[0];
        float xmax = this.x[this.x.length - 1];
        float xgap = this.x[1] - this.x[0];
        float ymin = this.y[0];
        float ymax = this.y[this.y.length - 1];
        float ygap = this.y[1] - this.y[0];
        for (int i = 0; i < xnew.length; ++i) {
            if (i < n) {
                xnew[i] = xmin - (float)(n - i) * xgap;
            } else if (i >= n && i < this.x.length + n) {
                xnew[i] = this.x[i - n];
            } else if (i >= this.x.length + n) {
                xnew[i] = xmax + (float)(i - (this.x.length + n) + 1) * xgap;
            }
            for (int j = 0; j < ynew.length; ++j) {
                if (j < n) {
                    ynew[j] = ymin - (float)(n - j) * ygap;
                    znew[i][j] = Float.NaN;
                    continue;
                }
                if (j >= n && j < this.y.length + n) {
                    ynew[j] = this.y[j - n];
                    if (i >= n && i < this.x.length + n) {
                        znew[i][j] = this.z[i - n][j - n];
                        continue;
                    }
                    znew[i][j] = Float.NaN;
                    continue;
                }
                if (j < this.y.length + n) continue;
                ynew[j] = ymax + (float)(j - (this.y.length + n) + 1) * ygap;
                znew[i][j] = Float.NaN;
            }
        }
        float olddiameter = xgap * (float)this.x.length / 2.0f;
        float newdiameter = xgap * (float)(this.x.length - 1 + n * 2) / 2.0f;
        olddiameter *= olddiameter;
        newdiameter *= newdiameter;
        int xmiddle = (xnew.length - 1) / 2;
        int ymiddle = (ynew.length - 1) / 2;
        for (int i = xmiddle; i < xnew.length; ++i) {
            for (int j = ymiddle; j < ynew.length; ++j) {
                float sqrad = xnew[i] * xnew[i] + ynew[j] * ynew[j];
                if (sqrad < olddiameter) continue;
                if (sqrad < newdiameter && sqrad >= olddiameter) {
                    int xopp = i - 2 * (i - xmiddle);
                    int yopp = j - 2 * (j - ymiddle);
                    znew[i][j] = this.getExtrapolatedZ(znew, i, j);
                    znew[xopp][j] = this.getExtrapolatedZ(znew, xopp, j);
                    znew[i][yopp] = this.getExtrapolatedZ(znew, i, yopp);
                    znew[xopp][yopp] = this.getExtrapolatedZ(znew, xopp, yopp);
                    continue;
                }
                znew[i][j] = Float.NaN;
            }
        }
        this.x = xnew;
        this.y = ynew;
        this.z = znew;
    }

    private float getExtrapolatedZ(float[][] grid, int currentXi, int currentYi) {
        int left = currentXi - 1 > 0 ? currentXi - 1 : currentXi;
        int right = currentXi + 1 < grid.length ? currentXi + 1 : currentXi;
        int bottom = currentYi - 1 > 0 ? currentYi - 1 : currentYi;
        int up = currentYi + 1 < grid[0].length ? currentYi + 1 : currentYi;
        float cumval = 0.0f;
        int nval = 0;
        for (int u = left; u <= right; ++u) {
            for (int v = bottom; v <= up; ++v) {
                if (Float.isNaN(grid[u][v])) continue;
                cumval += grid[u][v];
                ++nval;
            }
        }
        if (nval > 0) {
            return cumval / (float)nval;
        }
        return Float.NaN;
    }

    public List<Polygon> getInterpolatedRingPolygons(float ringMin, float ringMax, ColorMapper cmap, Color colorFactor) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (int xi = 1; xi < this.x.length - 1; ++xi) {
            for (int yi = 1; yi < this.y.length - 1; ++yi) {
                Point[] p = new Point[]{new Point(new Coord3d((this.x[xi - 1] + this.x[xi]) / 2.0f, (this.y[yi + 1] + this.y[yi]) / 2.0f, (this.z[xi - 1][yi + 1] + this.z[xi - 1][yi] + this.z[xi][yi] + this.z[xi][yi + 1]) / 4.0f)), new Point(new Coord3d((this.x[xi - 1] + this.x[xi]) / 2.0f, (this.y[yi - 1] + this.y[yi]) / 2.0f, (this.z[xi - 1][yi] + this.z[xi - 1][yi - 1] + this.z[xi][yi - 1] + this.z[xi][yi]) / 4.0f)), new Point(new Coord3d((this.x[xi + 1] + this.x[xi]) / 2.0f, (this.y[yi - 1] + this.y[yi]) / 2.0f, (this.z[xi][yi] + this.z[xi][yi - 1] + this.z[xi + 1][yi - 1] + this.z[xi + 1][yi]) / 4.0f)), new Point(new Coord3d((this.x[xi + 1] + this.x[xi]) / 2.0f, (this.y[yi + 1] + this.y[yi]) / 2.0f, (this.z[xi][yi + 1] + this.z[xi][yi] + this.z[xi + 1][yi] + this.z[xi + 1][yi + 1]) / 4.0f))};
                p[0].setColor(cmap.getColor(p[0].xyz));
                p[1].setColor(cmap.getColor(p[1].xyz));
                p[2].setColor(cmap.getColor(p[2].xyz));
                p[3].setColor(cmap.getColor(p[3].xyz));
                p[0].rgb.mul(colorFactor);
                p[1].rgb.mul(colorFactor);
                p[2].rgb.mul(colorFactor);
                p[3].rgb.mul(colorFactor);
                float[] radius = new float[p.length];
                for (int i = 0; i < p.length; ++i) {
                    radius[i] = this.radius2d(p[i]);
                }
                boolean[] isIn = this.isInside(p, radius, ringMin, ringMax);
                if (!isIn[0] && !isIn[1] && !isIn[2] && !isIn[3]) continue;
                if (isIn[0] && isIn[1] && isIn[2] && isIn[3]) {
                    Polygon quad = new Polygon();
                    for (int pi = 0; pi < p.length; ++pi) {
                        quad.add(p[pi]);
                    }
                    polygons.add(quad);
                    continue;
                }
                Polygon polygon = new Polygon();
                int[] seq = new int[]{0, 1, 2, 3, 0};
                boolean[] done = new boolean[4];
                for (int pi = 0; pi < done.length; ++pi) {
                    done[pi] = false;
                }
                for (int s = 0; s < seq.length - 1; ++s) {
                    Point intersection;
                    float ringRadius;
                    if (isIn[seq[s]] && isIn[seq[s + 1]]) {
                        if (!done[seq[s]]) {
                            polygon.add(p[seq[s]]);
                            done[seq[s]] = true;
                        }
                        if (done[seq[s + 1]]) continue;
                        polygon.add(p[seq[s + 1]]);
                        done[seq[s + 1]] = true;
                        continue;
                    }
                    if (isIn[seq[s]] && !isIn[seq[s + 1]]) {
                        if (!done[seq[s]]) {
                            polygon.add(p[seq[s]]);
                            done[seq[s]] = true;
                        }
                        ringRadius = Math.abs(radius[seq[s + 1]] - ringMin) < Math.abs(radius[seq[s + 1]] - ringMax) ? ringMin : ringMax;
                        intersection = this.findPoint(p[seq[s]], p[seq[s + 1]], ringRadius);
                        intersection.setColor(cmap.getColor(intersection.xyz));
                        intersection.rgb.mul(colorFactor);
                        polygon.add(intersection);
                        continue;
                    }
                    if (isIn[seq[s]] || !isIn[seq[s + 1]]) continue;
                    ringRadius = Math.abs(radius[seq[s + 1]] - ringMin) < Math.abs(radius[seq[s + 1]] - ringMax) ? ringMin : ringMax;
                    intersection = this.findPoint(p[seq[s]], p[seq[s + 1]], ringRadius);
                    intersection.setColor(cmap.getColor(intersection.xyz));
                    intersection.rgb.mul(colorFactor);
                    polygon.add(intersection);
                    if (done[seq[s + 1]]) continue;
                    polygon.add(p[seq[s + 1]]);
                    done[seq[s + 1]] = true;
                }
                polygons.add(polygon);
            }
        }
        return polygons;
    }

    protected boolean[] isInside(Point[] p, float[] radius, float minRadius, float maxRadius) {
        boolean[] isIn = new boolean[]{!Float.isNaN(p[0].xyz.z) && radius[0] < maxRadius && radius[0] >= minRadius, !Float.isNaN(p[1].xyz.z) && radius[1] < maxRadius && radius[1] >= minRadius, !Float.isNaN(p[2].xyz.z) && radius[2] < maxRadius && radius[2] >= minRadius, !Float.isNaN(p[3].xyz.z) && radius[3] < maxRadius && radius[3] >= minRadius};
        return isIn;
    }

    protected float radius2d(Point p) {
        return (float)Math.sqrt(p.xyz.x * p.xyz.x + p.xyz.y * p.xyz.y);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Point findPoint(Point p1, Point p2, float ringRadius) {
        float z3;
        float y3;
        float x3;
        if (p1.xyz.x == p2.xyz.x) {
            x3 = p1.xyz.x;
            double alpha = Math.acos(x3 / ringRadius);
            if (p1.xyz.y < 0.0f && p2.xyz.y < 0.0f) {
                y3 = -((float)Math.sin(alpha)) * ringRadius;
            } else if (p1.xyz.y > 0.0f && p2.xyz.y > 0.0f) {
                y3 = (float)Math.sin(alpha) * ringRadius;
            } else {
                if (p1.xyz.y != -p2.xyz.y) throw new ArithmeticException("no alignement between p1(" + p1.xyz.x + "," + p1.xyz.y + "," + p1.xyz.z + ") and p2(" + p2.xyz.x + "," + p2.xyz.y + "," + p2.xyz.z + ")");
                y3 = 0.0f;
            }
            if (!Float.isNaN(p1.xyz.z) && Float.isNaN(p2.xyz.z)) {
                z3 = p1.xyz.z;
                return new Point(new Coord3d(x3, y3, z3));
            } else if (Float.isNaN(p1.xyz.z) && !Float.isNaN(p2.xyz.z)) {
                z3 = p2.xyz.z;
                return new Point(new Coord3d(x3, y3, z3));
            } else {
                if (Float.isNaN(p1.xyz.z) || Float.isNaN(p2.xyz.z)) throw new ArithmeticException("can't compute z3 with p1(" + p1.xyz.x + "," + p1.xyz.y + ") and p2(" + p2.xyz.x + "," + p2.xyz.y + ")");
                float w2 = (float)(Math.sqrt((x3 - p1.xyz.x) * (x3 - p1.xyz.x) + (y3 - p1.xyz.y) * (y3 - p1.xyz.y)) / Math.sqrt((p2.xyz.x - p1.xyz.x) * (p2.xyz.x - p1.xyz.x) + (p2.xyz.y - p1.xyz.y) * (p2.xyz.y - p1.xyz.y)));
                float w1 = 1.0f - w2;
                z3 = w1 * p1.xyz.z + w2 * p2.xyz.z;
            }
            return new Point(new Coord3d(x3, y3, z3));
        } else {
            if (p1.xyz.y != p2.xyz.y) throw new ArithmeticException("no alignement between p1(" + p1.xyz.x + "," + p1.xyz.y + ") and p2(" + p2.xyz.x + "," + p2.xyz.y + ")");
            y3 = p1.xyz.y;
            double alpha = Math.asin(y3 / ringRadius);
            if (p1.xyz.x < 0.0f && p2.xyz.x < 0.0f) {
                x3 = -((float)Math.cos(alpha)) * ringRadius;
            } else if (p1.xyz.x > 0.0f && p2.xyz.x > 0.0f) {
                x3 = (float)Math.cos(alpha) * ringRadius;
            } else {
                if (p1.xyz.x != -p2.xyz.x) throw new ArithmeticException("no alignement between p1(" + p1.xyz.x + "," + p1.xyz.y + "," + p1.xyz.z + ") and p2(" + p2.xyz.x + "," + p2.xyz.y + "," + p2.xyz.z + ")");
                x3 = 0.0f;
            }
            if (!Float.isNaN(p1.xyz.z) && Float.isNaN(p2.xyz.z)) {
                z3 = p1.xyz.z;
                return new Point(new Coord3d(x3, y3, z3));
            } else if (Float.isNaN(p1.xyz.z) && !Float.isNaN(p2.xyz.z)) {
                z3 = p2.xyz.z;
                return new Point(new Coord3d(x3, y3, z3));
            } else {
                if (Float.isNaN(p1.xyz.z) || Float.isNaN(p2.xyz.z)) throw new ArithmeticException("can't compute z3 with p1(" + p1.xyz.x + "," + p1.xyz.y + ") and p2(" + p2.xyz.x + "," + p2.xyz.y + ")");
                float w2 = (float)(Math.sqrt((x3 - p1.xyz.x) * (x3 - p1.xyz.x) + (y3 - p1.xyz.y) * (y3 - p1.xyz.y)) / Math.sqrt((p2.xyz.x - p1.xyz.x) * (p2.xyz.x - p1.xyz.x) + (p2.xyz.y - p1.xyz.y) * (p2.xyz.y - p1.xyz.y)));
                float w1 = 1.0f - w2;
                z3 = w1 * p1.xyz.z + w2 * p2.xyz.z;
            }
        }
        return new Point(new Coord3d(x3, y3, z3));
    }
}

