/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot2d.primitives;

import java.util.List;
import org.jzy3d.colors.Color;
import org.jzy3d.maths.Coord2d;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.plot2d.primitives.Serie2d;
import org.jzy3d.plot3d.primitives.ConcurrentLineStrip;
import org.jzy3d.plot3d.primitives.Point;

public class LineSerie2d
implements Serie2d {
    protected ConcurrentLineStrip line;
    protected String name;

    public LineSerie2d(String name) {
        this.name = name;
        this.line = new ConcurrentLineStrip();
    }

    @Override
    public void add(float x, float y) {
        this.line.add(new Point(new Coord3d(x, y, 0.0f)));
    }

    @Override
    public void add(double x, double y) {
        this.line.add(new Point(new Coord3d(x, y, 0.0)));
    }

    @Override
    public void add(Coord2d c) {
        this.line.add(new Point(new Coord3d(c.x, c.y, 0.0f)));
    }

    @Override
    public void add(Coord2d c, Color color) {
        this.line.add(new Point(new Coord3d(c.x, c.y, 0.0f), color));
    }

    @Override
    public void add(float x, float y, Color color) {
        this.line.add(new Point(new Coord3d(x, y, 0.0f), color));
    }

    @Override
    public void add(double x, double y, Color color) {
        this.line.add(new Point(new Coord3d(x, y, 0.0), color));
    }

    @Override
    public void add(List<Coord2d> c) {
        for (Coord2d c2 : c) {
            this.line.add(new Point(new Coord3d(c2.x, c2.y, 0.0f)));
        }
    }

    @Override
    public void setColor(Color color) {
        this.line.setWireframeColor(color);
    }

    @Override
    public Color getColor() {
        return this.line.getWireframeColor();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ConcurrentLineStrip getDrawable() {
        return this.line;
    }

    @Override
    public void clear() {
        this.line.clear();
    }

    @Override
    public void setWidth(int width) {
        this.line.setWireframeWidth(width);
    }
}

