/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.plot2d.primitive;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.ColorAWT;
import org.jzy3d.colors.ColorMapper;
import org.jzy3d.colors.colormaps.IColorMap;
import org.jzy3d.plot2d.primitive.AWTAbstractImageGenerator;
import org.jzy3d.plot2d.primitive.AWTImageGenerator;
import org.jzy3d.plot3d.primitives.axes.layout.providers.ITickProvider;
import org.jzy3d.plot3d.primitives.axes.layout.renderers.ITickRenderer;

public class AWTColorbarImageGenerator
extends AWTAbstractImageGenerator
implements AWTImageGenerator {
    protected ColorMapper mapper;
    protected ITickProvider provider;
    protected ITickRenderer renderer;
    protected double min;
    protected double max;

    public AWTColorbarImageGenerator(IColorMap map, float min, float max, ITickProvider provider, ITickRenderer renderer) {
        this.mapper = new ColorMapper(map, min, max);
        this.min = min;
        this.max = max;
        this.provider = provider;
        this.renderer = renderer;
    }

    public AWTColorbarImageGenerator(ColorMapper mapper, ITickProvider provider, ITickRenderer renderer) {
        this.mapper = mapper;
        this.provider = provider;
        this.renderer = renderer;
        this.min = mapper.getMin();
        this.max = mapper.getMax();
        this.textSize = 12;
        this.font = new Font("Arial", 0, this.textSize);
    }

    @Override
    public BufferedImage toImage(int width, int height) {
        return this.toImage(width, height, 20);
    }

    public BufferedImage toImage(int width, int height, int barWidth) {
        if (barWidth > width) {
            return null;
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D graphic = image.createGraphics();
        this.configureText(graphic);
        this.drawBackground(width, height, graphic);
        this.drawBarColors(height, barWidth, graphic);
        this.drawBarContour(height, barWidth, graphic);
        this.drawTextAnnotations(height, barWidth, graphic);
        return image;
    }

    public void drawBarContour(int height, int barWidth, Graphics2D graphic) {
        graphic.setColor(ColorAWT.toAWT(this.foregroundColor));
        graphic.drawRect(0, this.textSize / 2, barWidth, height - this.textSize);
    }

    public void drawBarColors(int height, int barWidth, Graphics2D graphic) {
        for (int h = this.textSize / 2; h <= height - this.textSize / 2; ++h) {
            double v = this.min + (this.max - this.min) * (double)h / (double)(height - this.textSize);
            Color c = this.mapper.getColor(v);
            graphic.setColor(ColorAWT.toAWT(c));
            graphic.drawLine(0, height - h, barWidth, height - h);
        }
    }

    public void drawTextAnnotations(int height, int barWidth, Graphics2D graphic) {
        if (this.provider != null) {
            double[] ticks = this.provider.generateTicks(this.min, this.max);
            for (int t = 0; t < ticks.length; ++t) {
                int ypos = (int)((double)this.textSize + ((double)(height - this.textSize) - (double)(height - this.textSize) * ((ticks[t] - this.min) / (this.max - this.min))));
                String txt = this.renderer.format(ticks[t]);
                graphic.drawString(txt, barWidth + 1, ypos);
            }
        }
    }
}

