/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.maths.algorithms.interpolation.algorithms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.algorithms.interpolation.algorithms.BernsteinPolynomial;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Spline3D {
    public static final float DEFAULT_TIGHTNESS = 0.25f;
    @XmlElement
    protected Coord3d[] points;
    @XmlElement(name="p")
    public List<Coord3d> pointList = new ArrayList<Coord3d>();
    @XmlTransient
    public List<Coord3d> vertices;
    @XmlTransient
    public BernsteinPolynomial bernstein;
    @XmlTransient
    public Coord3d[] delta;
    @XmlTransient
    public Coord3d[] coeffA;
    @XmlTransient
    public float[] bi;
    @XmlAttribute
    protected float tightness;
    @XmlTransient
    protected float invTightness;
    @XmlTransient
    protected int numP;

    public Spline3D() {
        this.setTightness(0.25f);
    }

    public Spline3D(List<Coord3d> rawPoints) {
        this(rawPoints, null, 0.25f);
    }

    public Spline3D(List<Coord3d> rawPoints, BernsteinPolynomial b, float tightness) {
        this.pointList.addAll(rawPoints);
        this.bernstein = b;
        this.setTightness(tightness);
    }

    public Spline3D(Coord3d[] pointArray) {
        this(pointArray, null, 0.25f);
    }

    public Spline3D(Coord3d[] pointArray, BernsteinPolynomial b, float tightness) {
        this(Arrays.asList(pointArray), b, tightness);
    }

    public Spline3D add(float x, float y, float z) {
        return this.add(new Coord3d(x, y, z));
    }

    public Spline3D add(Coord3d p) {
        this.pointList.add(p);
        return this;
    }

    public List<Coord3d> computeVertices(int res) {
        this.updateCoefficients();
        if (this.bernstein == null || this.bernstein.resolution != ++res) {
            this.bernstein = new BernsteinPolynomial(res);
        }
        if (this.vertices == null) {
            this.vertices = new ArrayList<Coord3d>();
        } else {
            this.vertices.clear();
        }
        this.findCPoints();
        Coord3d deltaP = new Coord3d();
        Coord3d deltaQ = new Coord3d();
        --res;
        for (int i = 0; i < this.numP - 1; ++i) {
            Coord3d p = this.points[i];
            Coord3d q = this.points[i + 1];
            deltaP.set(this.delta[i]).addSelf(p);
            deltaQ.set(q).subSelf(this.delta[i + 1]);
            for (int k = 0; k < res; ++k) {
                float x = p.x * this.bernstein.b0[k] + deltaP.x * this.bernstein.b1[k] + deltaQ.x * this.bernstein.b2[k] + q.x * this.bernstein.b3[k];
                float y = p.y * this.bernstein.b0[k] + deltaP.y * this.bernstein.b1[k] + deltaQ.y * this.bernstein.b2[k] + q.y * this.bernstein.b3[k];
                float z = p.z * this.bernstein.b0[k] + deltaP.z * this.bernstein.b1[k] + deltaQ.z * this.bernstein.b2[k] + q.z * this.bernstein.b3[k];
                this.vertices.add(new Coord3d(x, y, z));
            }
        }
        this.vertices.add(this.points[this.points.length - 1]);
        return this.vertices;
    }

    protected void findCPoints() {
        int i;
        this.bi[1] = -this.tightness;
        this.coeffA[1].set((this.points[2].x - this.points[0].x - this.delta[0].x) * this.tightness, (this.points[2].y - this.points[0].y - this.delta[0].y) * this.tightness, (this.points[2].z - this.points[0].z - this.delta[0].z) * this.tightness);
        for (i = 2; i < this.numP - 1; ++i) {
            this.bi[i] = -1.0f / (this.invTightness + this.bi[i - 1]);
            this.coeffA[i].set(-(this.points[i + 1].x - this.points[i - 1].x - this.coeffA[i - 1].x) * this.bi[i], -(this.points[i + 1].y - this.points[i - 1].y - this.coeffA[i - 1].y) * this.bi[i], -(this.points[i + 1].z - this.points[i - 1].z - this.coeffA[i - 1].z) * this.bi[i]);
        }
        for (i = this.numP - 2; i > 0; --i) {
            this.delta[i].set(this.coeffA[i].x + this.delta[i + 1].x * this.bi[i], this.coeffA[i].y + this.delta[i + 1].y * this.bi[i], this.coeffA[i].z + this.delta[i + 1].z * this.bi[i]);
        }
    }

    public List<Coord3d> getDecimatedVertices(float step) {
        ArrayList<Coord3d> steps = new ArrayList<Coord3d>();
        int num = this.vertices.size();
        Coord3d a = null;
        Coord3d b = this.vertices.get(0);
        Coord3d curr = b.clone();
        for (int i = 0; i < num - 1; ++i) {
            a = b;
            b = this.vertices.get(i + 1);
            Coord3d dir = b.sub(a);
            float segLen = 1.0f / dir.magSquared();
            Coord3d stepDir = dir.getNormalizedTo(step);
            curr.set(a.interpolateTo(b, curr.sub(a).dot(dir) * segLen));
            while (curr.sub(a).dot(dir) / segLen <= 1.0f) {
                steps.add(curr.clone());
                curr.addSelf(stepDir);
            }
        }
        return steps;
    }

    public int getNumPoints() {
        return this.numP;
    }

    public List<Coord3d> getPointList() {
        return this.pointList;
    }

    public float getTightness() {
        return this.tightness;
    }

    public Spline3D setPointList(List<Coord3d> plist) {
        this.pointList.clear();
        for (Coord3d p : plist) {
            this.add(p);
        }
        return this;
    }

    public Spline3D setTightness(float tightness) {
        this.tightness = tightness;
        this.invTightness = 1.0f / tightness;
        return this;
    }

    public void updateCoefficients() {
        this.numP = this.pointList.size();
        if (this.points == null || this.points != null && this.points.length != this.numP) {
            this.coeffA = new Coord3d[this.numP];
            this.delta = new Coord3d[this.numP];
            this.bi = new float[this.numP];
            for (int i = 0; i < this.numP; ++i) {
                this.coeffA[i] = new Coord3d();
                this.delta[i] = new Coord3d();
            }
            this.setTightness(this.tightness);
        }
        this.points = this.pointList.toArray(new Coord3d[0]);
    }
}

