/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.io.obj;

import com.jogamp.opengl.GL;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.apache.log4j.Logger;
import org.jzy3d.io.IGLLoader;
import org.jzy3d.io.obj.OBJFile;
import org.jzy3d.maths.BoundingBox3d;
import org.jzy3d.plot3d.primitives.vbo.drawable.DrawableVBO;

public class OBJFileLoader
implements IGLLoader<DrawableVBO> {
    static Logger logger = Logger.getLogger(OBJFileLoader.class);
    protected String filename;
    protected OBJFile obj;

    public OBJFileLoader(String filename) {
        this.filename = filename;
    }

    @Override
    public void load(GL gl, DrawableVBO drawable) {
        this.obj = new OBJFile();
        logger.info((Object)("Start loading OBJ file '" + this.filename + "'"));
        this.obj.loadModelFromFilename(this.filename);
        logger.info((Object)"Start compiling mesh");
        this.obj.compileModel();
        logger.info((Object)(this.obj.getPositionCount() + " vertices"));
        logger.info((Object)(this.obj.getIndexCount() / 3 + " triangles"));
        int size = this.obj.getIndexCount();
        int indexSize = size * 4;
        int vertexSize = this.obj.getCompiledVertexCount() * 4;
        int byteOffset = this.obj.getCompiledVertexSize() * 4;
        int normalOffset = this.obj.getCompiledNormalOffset() * 4;
        int dimensions = this.obj.getPositionSize();
        int pointer = 0;
        FloatBuffer vertices = this.obj.getCompiledVertices();
        IntBuffer indices = this.obj.getCompiledIndices();
        BoundingBox3d bounds = this.obj.computeBoundingBox();
        drawable.doConfigure(pointer, size, byteOffset, normalOffset, dimensions);
        drawable.doLoadArrayFloatBuffer(gl, vertexSize, vertices);
        drawable.doLoadElementIntBuffer(gl, indexSize, indices);
        drawable.doSetBoundingBox(bounds);
    }
}

