/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.io;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class SimpleFile {
    public static void write(String content, String file) throws Exception {
        SimpleFile.createParentFoldersIfNotExist(file);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        out.write(content);
        ((Writer)out).close();
    }

    public static void createParentFoldersIfNotExist(String file) {
        File parent = new File(file).getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
    }

    public static List<String> readFile(File file) throws IOException {
        return SimpleFile.read(file.getAbsolutePath());
    }

    public static List<String> read(String filename) throws IOException {
        ArrayList<String> output = new ArrayList<String>();
        File file = new File(filename);
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(fis);
        DataInputStream dis = new DataInputStream(bis);
        while (dis.available() != 0) {
            output.add(dis.readLine());
        }
        fis.close();
        bis.close();
        dis.close();
        return output;
    }

    public static String readAsString(String filename) throws Exception {
        return SimpleFile.readAsString(filename, "\n");
    }

    public static String readAsString(String filename, String newLineString) throws IOException {
        StringBuffer sb = new StringBuffer();
        File file = new File(filename);
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(fis);
        DataInputStream dis = new DataInputStream(bis);
        while (dis.available() != 0) {
            sb.append((CharSequence)new StringBuilder().append(dis.readLine()).append(newLineString));
        }
        fis.close();
        bis.close();
        dis.close();
        return sb.toString();
    }

    public static boolean isYounger(String file1, String file2) throws IOException {
        File f1 = new File(file1);
        File f2 = new File(file2);
        if (!f2.exists()) {
            return false;
        }
        if (!f1.exists()) {
            return true;
        }
        return f1.lastModified() > f2.lastModified();
    }
}

