/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.demos.drawing.vbo.barmodel.color;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jzy3d.colors.Color;
import org.jzy3d.colors.colormaps.IColorMap;
import org.jzy3d.demos.drawing.vbo.barmodel.color.KeyValColorMapper;
import org.jzy3d.demos.drawing.vbo.barmodel.color.MinMaxColormappable;
import org.jzy3d.io.KeyVal;

public class KeyRankColorMapper<K, V>
implements KeyValColorMapper<K, V> {
    Map<K, Color> colors;

    public KeyRankColorMapper(List<List<KeyVal<K, V>>> keyVals, IColorMap colormap) {
        TreeSet keys = new TreeSet();
        for (List<KeyVal<K, V>> row : keyVals) {
            for (KeyVal<K, V> column : row) {
                keys.add(column.key);
            }
        }
        this.initColormap(keys, colormap);
    }

    protected void initColormap(Set<K> keys, IColorMap colormap) {
        this.colors = new HashMap<K, Color>();
        MinMaxColormappable minmax = new MinMaxColormappable(0.0, keys.size());
        int i = 0;
        for (K k : keys) {
            Color c = colormap.getColor(minmax, i++);
            c.a = 0.75f;
            this.colors.put(k, c);
        }
    }

    @Override
    public Color getColor(KeyVal<K, V> keyVal) {
        return this.colors.get(keyVal.key);
    }
}

