/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.demos.chart2d;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.jzy3d.chart.Chart;
import org.jzy3d.chart2d.Chart2d;
import org.jzy3d.plot2d.primitives.Serie2d;
import org.jzy3d.plot3d.primitives.ConcurrentLineStrip;
import org.jzy3d.plot3d.primitives.axes.layout.IAxeLayout;
import org.jzy3d.plot3d.primitives.axes.layout.providers.PitchTickProvider;
import org.jzy3d.plot3d.primitives.axes.layout.renderers.PitchTickRenderer;
import org.jzy3d.ui.LookAndFeel;

public class Chart2dDemo {
    public static float duration = 60.0f;
    public static int interval = 50;
    public static int maxfreq = 880;
    public static int nOctave = 5;
    protected static long start;

    public static void main(String[] args) throws Exception {
        PitchAmpliControlCharts log = new PitchAmpliControlCharts(duration, maxfreq, nOctave);
        new TimeChartWindow(log.getCharts());
        Chart2dDemo.generateSamplesInTime(log);
    }

    public static void generateSamples(PitchAmpliControlCharts log, int n) throws InterruptedException {
        System.out.println("will generate " + n + " samples");
        for (int i = 0; i < n; ++i) {
            double pitch = Math.random() * (double)maxfreq;
            double ampli = Math.random();
            log.seriePitch.add(Chart2dDemo.time(n, i), pitch);
            log.serieAmpli.add(Chart2dDemo.time(n, i), ampli);
        }
    }

    public static double time(int n, int i) {
        return (double)i / (double)n * (double)duration;
    }

    public static void generateSamplesInTime(PitchAmpliControlCharts log) throws InterruptedException {
        System.out.println("will generate approx. " + duration * 1000.0f / (float)interval + " samples");
        Chart2dDemo.start();
        while (Chart2dDemo.elapsed() < (double)duration) {
            double pitch = Math.random() * (double)maxfreq;
            double ampli = Math.random();
            log.seriePitch.add(Chart2dDemo.elapsed(), pitch);
            log.serieAmpli.add(Chart2dDemo.elapsed(), ampli);
            Thread.sleep(interval);
        }
    }

    public static void start() {
        start = System.nanoTime();
    }

    public static double elapsed() {
        return (double)(System.nanoTime() - start) / 1.0E9;
    }

    public static class TimeChartWindow
    extends JFrame {
        private static final long serialVersionUID = 7519209038396190502L;

        public TimeChartWindow(List<Chart> charts) throws IOException {
            LookAndFeel.apply();
            String lines = "[300px]";
            String columns = "[500px,grow]";
            this.setLayout((LayoutManager)new MigLayout("", columns, lines));
            int k = 0;
            for (Chart c : charts) {
                this.addChart(c, k++);
            }
            this.windowExitListener();
            this.pack();
            this.show();
            this.setVisible(true);
        }

        public void addChart(Chart chart, int id) {
            JPanel chartPanel = new JPanel(new BorderLayout());
            Border b = BorderFactory.createLineBorder(Color.black);
            chartPanel.setBorder(b);
            chartPanel.add((Component)((Object)chart.getCanvas()), "Center");
            this.add((Component)chartPanel, "cell 0 " + id + ", grow");
        }

        public void windowExitListener() {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    TimeChartWindow.this.dispose();
                    System.exit(0);
                }
            });
        }
    }

    public static class PitchAmpliControlCharts {
        public Chart2d pitchChart = new Chart2d();
        public Chart2d ampliChart;
        public Serie2d seriePitch;
        public Serie2d serieAmpli;
        public ConcurrentLineStrip pitchLineStrip;
        public ConcurrentLineStrip amplitudeLineStrip;

        public PitchAmpliControlCharts(float timeMax, int freqMax, int nOctave) {
            this.pitchChart.asTimeChart(timeMax, 0.0f, freqMax, "Time", "Frequency");
            IAxeLayout axe = this.pitchChart.getAxeLayout();
            axe.setYTickProvider(new PitchTickProvider(nOctave));
            axe.setYTickRenderer(new PitchTickRenderer());
            this.seriePitch = this.pitchChart.getSerie("frequency", Serie2d.Type.LINE);
            this.seriePitch.setColor(org.jzy3d.colors.Color.BLUE);
            this.pitchLineStrip = (ConcurrentLineStrip)this.seriePitch.getDrawable();
            this.ampliChart = new Chart2d();
            this.ampliChart.asTimeChart(timeMax, 0.0f, 1.1f, "Time", "Amplitude");
            this.serieAmpli = this.ampliChart.getSerie("amplitude", Serie2d.Type.LINE);
            this.serieAmpli.setColor(org.jzy3d.colors.Color.RED);
            this.amplitudeLineStrip = (ConcurrentLineStrip)this.serieAmpli.getDrawable();
        }

        public List<Chart> getCharts() {
            ArrayList<Chart> charts = new ArrayList<Chart>();
            charts.add(this.pitchChart);
            charts.add(this.ampliChart);
            return charts;
        }
    }
}

