/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.contour;

import org.jzy3d.colors.Color;
import org.jzy3d.contour.AbstractContourGenerator;
import org.jzy3d.contour.DefaultContourColoringPolicy;
import org.jzy3d.contour.IContourColoringPolicy;
import org.jzy3d.contour.IContourMeshGenerator;
import org.jzy3d.maths.Coord3d;
import org.jzy3d.maths.IntegerCoord2d;
import org.jzy3d.maths.Range;
import org.jzy3d.maths.Utils;
import org.jzy3d.plot3d.builder.Mapper;
import org.jzy3d.plot3d.primitives.LineStrip;
import org.jzy3d.plot3d.primitives.Point;
import org.jzy3d.plot3d.primitives.contour.ContourMesh;

public class MapperContourMeshGenerator
extends AbstractContourGenerator
implements IContourMeshGenerator {
    public static int PIXEL_NEIGHBOUR_THRESHOLD = 2;
    public static float LINE_STRIP_WIDTH = 2.0f;
    public static int MERGE_STRIP_DIST = 1;
    protected Mapper mapper;
    protected Range xrange;
    protected Range yrange;

    public MapperContourMeshGenerator(Mapper mapper, Range xrange, Range yrange) {
        this.mapper = mapper;
        this.xrange = xrange;
        this.yrange = yrange;
    }

    @Override
    public ContourMesh getContourMesh(IContourColoringPolicy policy, int xRes, int yRes, int nLevels, float planeAxe, boolean writeText) {
        double[][] contours = this.computeContour(xRes, yRes, nLevels);
        return this.computeMesh(policy, xRes, yRes, contours, planeAxe);
    }

    @Override
    public ContourMesh getContourMesh(IContourColoringPolicy policy, int xRes, int yRes, double[] sortedLevels, float planeAxe, boolean writeText) {
        for (int n = 1; n < sortedLevels.length; ++n) {
            if (!(sortedLevels[n] < sortedLevels[n - 1])) continue;
            throw new RuntimeException("Levels sent to getContourStrips() are not in order from Min to Max");
        }
        double[][] contours = this.computeContour(xRes, yRes, sortedLevels);
        return this.computeMesh(policy, xRes, yRes, contours, planeAxe);
    }

    @Override
    public double[][] getContourMatrix(int xRes, int yRes, int nLevels) {
        return this.computeContour(xRes, yRes, nLevels);
    }

    protected ContourMesh computeMesh(IContourColoringPolicy policy, int xRes, int yRes, double[][] contours, float planeAxe) {
        boolean[][] processed = new boolean[xRes][yRes];
        ContourMesh mesh = new ContourMesh();
        for (int i = 0; i < contours.length; ++i) {
            for (int j = 0; j < contours[i].length; ++j) {
                if (processed[i][j] || contours[i][j] == NON_CONTOUR) continue;
                double level = contours[i][j];
                LineStrip strip = this.followContourFrom((DefaultContourColoringPolicy)policy, i, j, contours, processed, planeAxe);
                strip.setWidth(LINE_STRIP_WIDTH);
                mesh.lines.appendLevelLine(level, strip);
                mesh.setLevelLabel(level, Utils.num2str('f', level, 2));
            }
        }
        return mesh;
    }

    protected LineStrip followContourFrom(DefaultContourColoringPolicy policy, int i, int j, double[][] contours, boolean[][] processed, float planeAxe) {
        LineStrip strip = new LineStrip(100);
        processed[i][j] = true;
        strip.add(new Point(this.map(i, j, planeAxe, contours)));
        int width = 1;
        IntegerCoord2d next = this.findNext(i, j, width, contours, processed);
        while (next != null) {
            processed[next.x][next.y] = true;
            Coord3d coord = this.map(next.x, next.y, planeAxe, contours);
            Color color = policy.getColorMapper().getColor(new Coord3d(0.0, 0.0, contours[next.x][next.y]));
            strip.add(new Point(coord, color));
            next = this.findNext(next.x, next.y, width, contours, processed);
        }
        return strip;
    }

    protected IntegerCoord2d findNext(int i, int j, int width, double[][] contours, boolean[][] processed) {
        int iFrom = i > width - 1 ? i - width : i;
        int iTo = i < contours.length - width ? i + width : i;
        int jFrom = j > width - 1 ? j - width : j;
        int jTo = j < contours[0].length - width ? j + width : j;
        int n = 0;
        for (int ii = iFrom; ii <= iTo; ++ii) {
            for (int jj = jFrom; jj <= jTo; ++jj) {
                ++n;
                if (processed[ii][jj] || contours[ii][jj] == NON_CONTOUR) continue;
                return new IntegerCoord2d(ii, jj);
            }
        }
        if (width < PIXEL_NEIGHBOUR_THRESHOLD) {
            return this.findNext(i, j, width + 1, contours, processed);
        }
        return null;
    }

    protected Coord3d map(int i, int j, double[][] contours) {
        return this.map(i, j, contours[i][j], contours);
    }

    protected Coord3d map(int i, int j, double value, double[][] contours) {
        double xrng = this.xrange.getRange();
        double yrng = this.yrange.getRange();
        double x = (double)this.xrange.getMin() + xrng * ((double)i / (double)contours.length);
        double y = (double)this.yrange.getMin() + yrng * ((double)(contours[0].length - j) / (double)contours[0].length);
        return new Coord3d(x, y, value);
    }

    @Override
    protected void computeHeightMatrix(double[][] matrix, int xRes, int yRes) {
        this.minValue = Double.MAX_VALUE;
        this.maxValue = -1.7976931348623157E308;
        double xstep = (double)this.xrange.getRange() / (double)(xRes - 1);
        double ystep = (double)this.yrange.getRange() / (double)(yRes - 1);
        for (int xi = 0; xi < xRes; ++xi) {
            for (int yi = 0; yi < yRes; ++yi) {
                double value;
                double x = (double)this.xrange.getMin() + (double)xi * xstep;
                double y = (double)this.yrange.getMin() + (double)yi * ystep;
                matrix[xi][yRes - 1 - yi] = value = this.mapper.f(x, y);
                if (value < this.minValue) {
                    this.minValue = value;
                }
                if (!(value > this.maxValue)) continue;
                this.maxValue = value;
            }
        }
    }
}

