/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.contour;

public abstract class AbstractContourGenerator {
    protected static double NON_CONTOUR = -1.7976931348623157E308;
    protected double minValue;
    protected double maxValue;

    protected abstract void computeHeightMatrix(double[][] var1, int var2, int var3);

    protected double[][] computeContour(int xRes, int yRes, int nLevels) {
        double[][] matrix = new double[xRes][yRes];
        double[][] contours = new double[xRes][yRes];
        this.computeHeightMatrix(matrix, xRes, yRes);
        this.quantizeMatrix(matrix, this.minValue, this.maxValue, nLevels);
        this.extractCountours(contours, matrix, xRes, yRes);
        return contours;
    }

    protected double[][] computeContour(int xRes, int yRes, double[] sortedLevels) {
        double[][] matrix = new double[xRes][yRes];
        double[][] contours = new double[xRes][yRes];
        this.computeHeightMatrix(matrix, xRes, yRes);
        this.quantizeMatrix(matrix, sortedLevels);
        this.extractCountours(contours, matrix, xRes, yRes);
        return contours;
    }

    protected double[][] computeFilledContour(int xRes, int yRes, int nLevels) {
        double[][] matrix = new double[xRes][yRes];
        this.computeHeightMatrix(matrix, xRes, yRes);
        this.quantizeMatrix(matrix, this.minValue, this.maxValue, nLevels);
        return matrix;
    }

    protected double[][] computeXYColors(int xRes, int yRes, int nLevels) {
        double[][] matrix = new double[xRes][yRes];
        this.computeHeightMatrix(matrix, xRes, yRes);
        return matrix;
    }

    protected void quantizeMatrix(double[][] matrix, double[] sortedLevels) {
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                double value = matrix[i][j];
                matrix[i][j] = NON_CONTOUR;
                for (int n = 0; n < sortedLevels.length; ++n) {
                    if (value >= sortedLevels[n]) {
                        matrix[i][j] = sortedLevels[n];
                        continue;
                    }
                    n = sortedLevels.length;
                }
            }
        }
    }

    protected void quantizeMatrix(double[][] matrix, double min, double max, int n) {
        double step = (max - min) / (double)n;
        for (int i = 0; i < matrix.length; ++i) {
            for (int j = 0; j < matrix[i].length; ++j) {
                matrix[i][j] = step * (double)((int)(matrix[i][j] / step));
            }
        }
    }

    protected void extractCountours(double[][] contours, double[][] matrix, int xSpan, int ySpan) {
        int x;
        for (x = 1; x < xSpan - 1; ++x) {
            for (int y = 1; y < ySpan - 1; ++y) {
                contours[x][y] = matrix[x][y] > matrix[x - 1][y - 1] || matrix[x][y] > matrix[x][y - 1] || matrix[x][y] > matrix[x + 1][y - 1] || matrix[x][y] > matrix[x - 1][y] || matrix[x][y] > matrix[x + 1][y] || matrix[x][y] > matrix[x - 1][y + 1] || matrix[x][y] > matrix[x][y + 1] || matrix[x][y] > matrix[x + 1][y + 1] ? matrix[x][y] : NON_CONTOUR;
            }
        }
        for (x = 1; x < xSpan - 1; ++x) {
            contours[x][0] = contours[x][1] != NON_CONTOUR && contours[x - 1][1] == NON_CONTOUR && contours[x + 1][1] == NON_CONTOUR ? contours[x][1] : NON_CONTOUR;
            contours[x][ySpan - 1] = contours[x][ySpan - 2] != NON_CONTOUR && contours[x - 1][ySpan - 2] == NON_CONTOUR && contours[x + 1][ySpan - 2] == NON_CONTOUR ? contours[x][ySpan - 2] : NON_CONTOUR;
        }
        for (int y = 1; y < ySpan - 1; ++y) {
            contours[0][y] = contours[1][y] != NON_CONTOUR && contours[1][y - 1] == NON_CONTOUR && contours[1][y + 1] == NON_CONTOUR ? contours[1][y] : NON_CONTOUR;
            contours[xSpan - 1][y] = contours[xSpan - 2][y] != NON_CONTOUR && contours[xSpan - 2][y - 1] == NON_CONTOUR && contours[xSpan - 2][y + 1] == NON_CONTOUR ? contours[xSpan - 2][y] : NON_CONTOUR;
        }
    }
}

