/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.colors.colormaps;

import org.jzy3d.colors.Color;
import org.jzy3d.colors.IColorMappable;
import org.jzy3d.colors.colormaps.IColorMap;

public abstract class AbstractColorMap
implements IColorMap {
    protected boolean direction = true;

    public abstract Color getColor(double var1, double var3, double var5, double var7, double var9);

    @Override
    public void setDirection(boolean isStandard) {
        this.direction = isStandard;
    }

    @Override
    public boolean getDirection() {
        return this.direction;
    }

    @Override
    public Color getColor(IColorMappable colorable, double x, double y, double z) {
        return this.getColor(x, y, z, colorable.getMin(), colorable.getMax());
    }

    protected double processRelativeZValue(double z, double zMin, double zMax) {
        double rel_value = 0.0;
        rel_value = z < zMin ? (this.direction ? 0.0 : 1.0) : (z > zMax ? (this.direction ? 1.0 : 0.0) : (this.direction ? (z - zMin) / (zMax - zMin) : (zMax - z) / (zMax - zMin)));
        return rel_value;
    }

    @Override
    public Color getColor(IColorMappable colorable, double z) {
        return this.getColor(0.0, 0.0, z, colorable.getMin(), colorable.getMax());
    }

    @Override
    public double colorComponentRelative(double value, double center, double topwidth, double bottomwidth) {
        return this.colorComponentAbsolute(value, center - bottomwidth / 2.0, center + bottomwidth / 2.0, center - topwidth / 2.0, center + topwidth / 2.0);
    }

    public double colorComponentRelativeNoLeftBorder(double value, double center, double topwidth, double bottomwidth) {
        return this.colorComponentAbsolute(value, center - bottomwidth / 2.0, center + bottomwidth / 2.0, center - bottomwidth / 2.0, center + topwidth / 2.0);
    }

    public double colorComponentRelativeNoRightBorder(double value, double center, double topwidth, double bottomwidth) {
        return this.colorComponentAbsolute(value, center - bottomwidth / 2.0, center + bottomwidth / 2.0, center - topwidth / 2.0, center + bottomwidth / 2.0);
    }

    @Override
    public double colorComponentAbsolute(double value, double bLeft, double bRight, double tLeft, double tRight) {
        double output = 0.0;
        if (value < bLeft || value >= bRight) {
            output = 0.0;
        } else if (value >= tLeft && value < tRight) {
            output = 1.0;
        } else if (value >= bLeft && value < tLeft) {
            output = (value - bLeft) / (tLeft - bLeft);
        } else if (value >= tRight && value < bRight) {
            output = (value - bRight) / (tRight - bRight);
        }
        return output;
    }
}

