/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.colors;

import java.util.Random;

public class Color {
    public static final Color BLACK = new Color(0.0f, 0.0f, 0.0f);
    public static final Color WHITE = new Color(1.0f, 1.0f, 1.0f);
    public static final Color GRAY = new Color(0.5f, 0.5f, 0.5f);
    public static final Color RED = new Color(1.0f, 0.0f, 0.0f);
    public static final Color GREEN = new Color(0.0f, 1.0f, 0.0f);
    public static final Color BLUE = new Color(0.0f, 0.0f, 1.0f);
    public static final Color YELLOW = new Color(1.0f, 1.0f, 0.0f);
    public static final Color MAGENTA = new Color(1.0f, 0.0f, 1.0f);
    public static final Color CYAN = new Color(0.0f, 1.0f, 1.0f);
    public static final Color[] COLORS = new Color[]{RED, GREEN, BLUE, YELLOW, MAGENTA, CYAN};
    public static Random rng = new Random();
    public float r;
    public float g;
    public float b;
    public float a;

    public Color(float r, float g, float b) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = 1.0f;
    }

    public Color(int r, int g, int b) {
        this.r = (float)r / 255.0f;
        this.g = (float)g / 255.0f;
        this.b = (float)b / 255.0f;
        this.a = 1.0f;
    }

    public Color(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public Color(int r, int g, int b, int a) {
        this.r = (float)r / 255.0f;
        this.g = (float)g / 255.0f;
        this.b = (float)b / 255.0f;
        this.a = (float)a / 255.0f;
    }

    public void mul(Color factor) {
        this.r *= factor.r;
        this.g *= factor.g;
        this.b *= factor.b;
        this.a *= factor.a;
    }

    public Color alphaSelf(float alpha) {
        this.a = alpha;
        return this;
    }

    public String toHex() {
        String hexa = "#";
        hexa = hexa + Integer.toHexString((int)this.r * 255);
        hexa = hexa + Integer.toHexString((int)this.g * 255);
        hexa = hexa + Integer.toHexString((int)this.b * 255);
        return hexa;
    }

    public String toString() {
        return new String("(Color) r=" + this.r + " g=" + this.g + " b=" + this.b + " a=" + this.a);
    }

    public Color clone() {
        return new Color(this.r, this.g, this.b, this.a);
    }

    public float[] toArray() {
        float[] array = new float[]{this.r, this.g, this.b, this.a};
        return array;
    }

    public Color negative() {
        return new Color(1.0f - this.r, 1.0f - this.g, 1.0f - this.b);
    }

    public Color negativeSelf() {
        this.r = 1.0f - this.r;
        this.g = 1.0f - this.g;
        this.b = 1.0f - this.b;
        return this;
    }

    public static Color random() {
        return new Color(rng.nextFloat(), rng.nextFloat(), rng.nextFloat());
    }

    public static Color color(int c) {
        return COLORS[c % COLORS.length];
    }
}

