/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart.controllers.keyboard.camera;

import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.KeyListener;
import org.jzy3d.chart.Chart;
import org.jzy3d.chart.controllers.camera.AbstractCameraController;
import org.jzy3d.chart.controllers.keyboard.camera.ICameraKeyController;
import org.jzy3d.maths.Coord2d;

public class NewtCameraKeyController
extends AbstractCameraController
implements KeyListener,
ICameraKeyController {
    public NewtCameraKeyController() {
    }

    public NewtCameraKeyController(Chart chart) {
        this.register(chart);
    }

    @Override
    public void register(Chart chart) {
        super.register(chart);
        chart.getCanvas().addKeyController(this);
    }

    @Override
    public void dispose() {
        for (Chart c : this.targets) {
            c.getCanvas().removeKeyController(this);
        }
        super.dispose();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (!e.isShiftDown()) {
            Coord2d move = new Coord2d();
            float offset = 0.1f;
            switch (e.getKeyCode()) {
                case 152: {
                    move.y += offset;
                    this.rotate(move);
                    break;
                }
                case 150: {
                    move.y -= offset;
                    this.rotate(move);
                    break;
                }
                case 149: {
                    move.x -= offset;
                    this.rotate(move);
                    break;
                }
                case 151: {
                    move.x += offset;
                    this.rotate(move);
                    break;
                }
            }
        } else {
            switch (e.getKeyCode()) {
                case 152: {
                    this.shift(0.1f);
                    break;
                }
                case 150: {
                    this.shift(-0.1f);
                    break;
                }
                case 149: {
                    this.zoomZ(0.9f);
                    break;
                }
                case 151: {
                    this.zoomZ(1.1f);
                    break;
                }
            }
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
}

