/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart.controllers;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.jzy3d.chart.Chart;
import org.jzy3d.chart.controllers.ControllerType;
import org.jzy3d.events.ControllerEvent;
import org.jzy3d.events.ControllerEventListener;

public class AbstractController {
    protected List<Chart> targets;
    protected Vector<ControllerEventListener> controllerListeners = new Vector(1);

    public AbstractController() {
    }

    public AbstractController(Chart chart) {
        this.register(chart);
    }

    public void register(Chart chart) {
        if (this.targets == null) {
            this.targets = new ArrayList<Chart>(1);
        }
        this.targets.add(chart);
    }

    public void unregister(Chart chart) {
        if (this.targets != null) {
            this.targets.remove(chart);
        }
    }

    protected Chart chart() {
        return this.targets.get(0);
    }

    public void dispose() {
        this.targets.clear();
        this.controllerListeners.clear();
    }

    public void addControllerEventListener(ControllerEventListener listener) {
        this.controllerListeners.add(listener);
    }

    public void removeControllerEventListener(ControllerEventListener listener) {
        this.controllerListeners.remove(listener);
    }

    protected void fireControllerEvent(ControllerType type, Object value) {
        ControllerEvent e = new ControllerEvent(this, type, value);
        for (ControllerEventListener listener : this.controllerListeners) {
            listener.controllerEventFired(e);
        }
    }
}

