/*
 * Decompiled with CFR 0.152.
 */
package org.jzy3d.chart;

import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLProfile;

public class Settings {
    private static Settings instance;
    private GLCapabilities glCapabilities;
    private GLProfile glProfile;

    private Settings() {
        this(Settings.detectProfile());
    }

    private Settings(GLProfile glProfile) {
        this.glProfile = glProfile;
        this.glCapabilities = new GLCapabilities(glProfile);
        this.setHardwareAccelerated(false);
    }

    public static GLProfile detectProfile() {
        if (!GLProfile.isAvailable("GL2") && !GLProfile.isAvailable("GL2ES2")) {
            throw new UnsupportedOperationException("Jzy3d requires OpenGL 2 or OpenGL 2 ES 2");
        }
        if (GLProfile.isAvailable("GL2")) {
            return GLProfile.get("GL2");
        }
        return GLProfile.get("GL2ES2");
    }

    public static Settings getInstance() {
        if (instance == null) {
            instance = new Settings();
        }
        return instance;
    }

    public void setHardwareAccelerated(boolean hardwareAccelerated) {
        this.glCapabilities.setHardwareAccelerated(hardwareAccelerated);
    }

    public boolean isHardwareAccelerated() {
        return this.glCapabilities.getHardwareAccelerated();
    }

    public GLCapabilities getGLCapabilities() {
        return (GLCapabilities)this.glCapabilities.clone();
    }

    public String toString() {
        return "HardwareAcceleration = " + this.isHardwareAccelerated() + "\n";
    }
}

